% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census.R
\name{get_decennial}
\alias{get_decennial}
\title{Obtain data and feature geometry for the decennial US Census}
\usage{
get_decennial(
  geography,
  variables = NULL,
  table = NULL,
  cache_table = FALSE,
  year = 2010,
  sumfile = "sf1",
  state = NULL,
  county = NULL,
  geometry = FALSE,
  output = "tidy",
  keep_geo_vars = FALSE,
  shift_geo = FALSE,
  summary_var = NULL,
  key = NULL,
  show_call = FALSE,
  ...
)
}
\arguments{
\item{geography}{The geography of your data.}

\item{variables}{Character string or vector of character strings of variable
IDs.}

\item{table}{The Census table for which you would like to request all variables. Uses
lookup tables to identify the variables; performs faster when variable
table already exists through \code{load_variables(cache = TRUE)}.
Only one table may be requested per call.}

\item{cache_table}{Whether or not to cache table names for faster future access.
Defaults to FALSE; if TRUE, only needs to be called once per
dataset.  If variables dataset is already cached via the
\code{load_variables} function, this can be bypassed.}

\item{year}{The year for which you are requesting data. Defaults to 2010; 2000,
2010, and 2020 are available.}

\item{sumfile}{The Census summary file.  Defaults to sf1; the function will look in sf3 if it
cannot find a variable in sf1.}

\item{state}{The state for which you are requesting data. State
names, postal codes, and FIPS codes are accepted.
Defaults to NULL.}

\item{county}{The county for which you are requesting data. County names and
FIPS codes are accepted. Must be combined with a value supplied
to `state`.  Defaults to NULL.}

\item{geometry}{if FALSE (the default), return a regular tibble of ACS data.
if TRUE, uses the tigris package to return an sf tibble
with simple feature geometry in the `geometry` column.  state, county, tract, and block group are
supported for 2000 through 2020; block and ZCTA geometry are supported for 2000 and 2010.}

\item{output}{One of "tidy" (the default) in which each row represents an
enumeration unit-variable combination, or "wide" in which each
row represents an enumeration unit and the variables are in the
columns.}

\item{keep_geo_vars}{if TRUE, keeps all the variables from the Census
shapefile obtained by tigris.  Defaults to FALSE.}

\item{shift_geo}{(deprecated) if TRUE, returns geometry with Alaska and Hawaii
shifted for thematic mapping of the entire US.
Geometry was originally obtained from the albersusa R package.  As of May 2021,
we recommend using \code{tigris::shift_geometry()} instead.}

\item{summary_var}{Character string of a "summary variable" from the decennial Census
to be included in your output. Usually a variable (e.g. total population)
that you'll want to use as a denominator or comparison.}

\item{key}{Your Census API key.
Obtain one at \url{https://api.census.gov/data/key_signup.html}}

\item{show_call}{if TRUE, display call made to Census API. This can be very useful
in debugging and determining if error messages returned are
due to tidycensus or the Census API. Copy to the API call into
a browser and see what is returned by the API directly. Defaults to FALSE.}

\item{...}{Other keyword arguments}
}
\value{
a tibble or sf tibble of decennial Census data
}
\description{
Obtain data and feature geometry for the decennial US Census
}
\examples{
\dontrun{
# Plot of race/ethnicity by county in Illinois for 2010
library(tidycensus)
library(tidyverse)
library(viridis)
census_api_key("YOUR KEY GOES HERE")
vars10 <- c("P005003", "P005004", "P005006", "P004003")

il <- get_decennial(geography = "county", variables = vars10, year = 2010,
                    summary_var = "P001001", state = "IL", geometry = TRUE) \%>\%
  mutate(pct = 100 * (value / summary_value))

ggplot(il, aes(fill = pct, color = pct)) +
  geom_sf() +
  facet_wrap(~variable)


}
}
