% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.anova.R
\name{.fit.anova}
\alias{.fit.anova}
\title{ANOVA for \code{tidyfit}}
\usage{
\method{.fit}{anova}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Performs Analysis of Variance on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}} or \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}

The function provides a wrapper for \code{stats::anova}. See \code{?anova} for more details.

First a \code{glm} model is fitted which is passed to \code{anova}.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("anova", Return ~ `Mkt-RF` + HML + SMB, data)
fit

# Within 'regress' function
fit <- regress(data, Return ~ ., m("anova"), .mask = c("Date", "Industry"))
tidyr::unnest(coef(fit), model_info)

}
\seealso{
\code{\link{.fit.lm}}, \code{\link{.fit.glm}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
