% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_frame.R, R/data_tree.R, R/dendrogram.R,
%   R/graph.R, R/hclust.R, R/igraph.R, R/list.R, R/matrix.R, R/network.R,
%   R/phylo.R, R/tbl_graph.R
\name{as_tbl_graph.data.frame}
\alias{as_tbl_graph.data.frame}
\alias{as_tbl_graph.Node}
\alias{as_tbl_graph.dendrogram}
\alias{as_tbl_graph.graphNEL}
\alias{as_tbl_graph.graphAM}
\alias{as_tbl_graph.graphBAM}
\alias{as_tbl_graph.hclust}
\alias{as_tbl_graph.igraph}
\alias{as_tbl_graph.list}
\alias{as_tbl_graph.matrix}
\alias{as_tbl_graph.network}
\alias{as_tbl_graph.phylo}
\alias{as_tbl_graph.evonet}
\alias{tbl_graph}
\alias{as_tbl_graph}
\alias{as_tbl_graph.default}
\alias{is.tbl_graph}
\title{A data structure for tidy graph manipulation}
\usage{
\method{as_tbl_graph}{data.frame}(x, directed = TRUE, ...)

\method{as_tbl_graph}{Node}(x, directed = TRUE, mode = "out", ...)

\method{as_tbl_graph}{dendrogram}(x, directed = TRUE, mode = "out", ...)

\method{as_tbl_graph}{graphNEL}(x, ...)

\method{as_tbl_graph}{graphAM}(x, ...)

\method{as_tbl_graph}{graphBAM}(x, ...)

\method{as_tbl_graph}{hclust}(x, directed = TRUE, mode = "out", ...)

\method{as_tbl_graph}{igraph}(x, ...)

\method{as_tbl_graph}{list}(x, directed = TRUE, ...)

\method{as_tbl_graph}{matrix}(x, directed = TRUE, ...)

\method{as_tbl_graph}{network}(x, ...)

\method{as_tbl_graph}{phylo}(x, directed = NULL, ...)

\method{as_tbl_graph}{evonet}(x, directed = TRUE, ...)

tbl_graph(nodes = NULL, edges = NULL, directed = TRUE)

as_tbl_graph(x, ...)

\method{as_tbl_graph}{default}(x, ...)

is.tbl_graph(x)
}
\arguments{
\item{x}{An object convertible to a \code{tbl_graph}}

\item{directed}{Should the constructed graph be directed (defaults to \code{TRUE})}

\item{...}{Arguments passed on to the conversion function}

\item{mode}{In case \code{directed = TRUE} should the edge direction be away from
node or towards. Possible values are \code{"out"} (default) or \code{"in"}.}

\item{nodes}{A \code{data.frame} containing information about the nodes in the
graph.}

\item{edges}{A \code{data.frame} containing information about the edges in the
graph. The terminal nodes of each edge must either be encoded in a \code{to} and
\code{from} column, or in the two first columns, as integers.}
}
\value{
A \code{tbl_graph} object
}
\description{
The \code{tbl_graph} class is a thin wrapper around an \code{igraph} object that
provides methods for manipulating the graph using the tidy API. As it is just
a subclass of \code{igraph} every igraph method will work as expected. A
\code{grouped_tbl_graph} is the equivalent of a \code{grouped_df} where either the
nodes or the edges has been grouped. The \code{grouped_tbl_graph} is not
constructed directly but by using the \code{\link[=group_by]{group_by()}} verb. After creation of a
\code{tble_graph} the nodes are activated by default. The context can be changed
using the \code{\link[=activate]{activate()}} verb and affects all subsequent operations. Changing
context automatically drops any grouping. The current active context can
always be extracted with \code{\link[=as_tibble]{as_tibble()}}, which drops the graph structure and
just returns a \code{tbl_df} or a \code{grouped_df} depending on the state of the
\code{tbl_graph}. The returned context can be overriden by using the \code{active}
argument in \code{\link[=as_tibble]{as_tibble()}}.
}
\details{
Constructors are provided for most data structures that resembles networks.
If a class provides an \code{\link[igraph:as.igraph]{igraph::as.igraph()}} method it is automatically
supported.
}
\section{Methods (by generic)}{
\itemize{
\item \code{as_tbl_graph}: Method for edge table

\item \code{as_tbl_graph}: Method to deal with Node objects from the data.tree package

\item \code{as_tbl_graph}: Method for dendrogram objects

\item \code{as_tbl_graph}: Method for handling graphNEL objects from the graph package (on Bioconductor)

\item \code{as_tbl_graph}: Method for handling graphAM objects from the graph package (on Bioconductor)

\item \code{as_tbl_graph}: Method for handling graphBAM objects from the graph package (on Bioconductor)

\item \code{as_tbl_graph}: Method for hclust objects

\item \code{as_tbl_graph}: Method for igraph object. Simply subclasses the object into a \code{tbl_graph}

\item \code{as_tbl_graph}: Method for adjacency lists and lists of node and edge tables

\item \code{as_tbl_graph}: Method for edgelist, adjacency and incidence matrices

\item \code{as_tbl_graph}: Method to handle network objects from the \code{network}
package. Requires this packages to work.

\item \code{as_tbl_graph}: Method for handling phylo objects from the ape package

\item \code{as_tbl_graph}: Method for handling evonet objects from the ape package

\item \code{as_tbl_graph}: Default method. tries to call \code{\link[igraph:as.igraph]{igraph::as.igraph()}} on the input.
}}

