% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tx_regimen.R
\name{tx_regimen}
\alias{tx_regimen}
\title{Subset Clients Based on their Current ART Regimen}
\usage{
tx_regimen(
  data,
  age_band = NULL,
  states = .s,
  facilities = .f,
  status = "calculated"
)
}
\arguments{
\item{data}{An NDR dataframe imported using the `read_ndr()}

\item{age_band}{a numeric vector of length 2 \code{c(min_age, max_age)}.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}

\item{status}{Determines how the number of active clients is calculated.
The options are to either to use the NDR current_status_28_days column
or the derived current_status column ("calculated").}
}
\value{
tx_regimen
}
\description{
Generates the line-list of clients on first-line regimen who are on the choice
combination regimen for their age or weight. The NDR does not currently report
'weight' so the function uses 'age' to approximate the choice-regimen for the
clients.
}
\examples{
tx_regimen(ndr_example)

tx_regimen(ndr_example,
  status = "default",
  age_band = c(0, 3)
)
}
