% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boyce_cont.R
\name{boyce_cont}
\alias{boyce_cont}
\alias{boyce_cont.data.frame}
\alias{boyce_cont.sf}
\alias{boyce_cont_vec}
\title{Boyce continuous index (BCI)}
\usage{
boyce_cont(data, ...)

\method{boyce_cont}{data.frame}(
  data,
  truth,
  ...,
  estimator = NULL,
  na_rm = TRUE,
  event_level = "first",
  case_weights = NULL
)

\method{boyce_cont}{sf}(data, ...)

boyce_cont_vec(
  truth,
  estimate,
  estimator = NULL,
  na_rm = TRUE,
  event_level = "first",
  case_weights = NULL,
  ...
)
}
\arguments{
\item{data}{Either a data.frame containing the columns specified by the truth
and estimate arguments, or a table/matrix where the true class
results should be in the columns of the table.}

\item{...}{A set of unquoted column names or one or more dplyr selector functions to choose which variables contain the class probabilities. If truth is binary, only 1 column should be selected, and it should correspond to the value of event_level. Otherwise, there should be as many columns as factor levels of truth and the ordering of the columns should be the same as the factor levels of truth.}

\item{truth}{The column identifier for the true class results (that is a factor). This should be an unquoted column name although this argument is passed by expression and supports quasiquotation (you can unquote column names). For _vec() functions, a factor vector.}

\item{estimator}{One of "binary", "hand_till", "macro", or "macro_weighted" to specify the type of averaging to be done. "binary" is only relevant for the two class case. The others are general methods for calculating multiclass metrics. The default will automatically choose "binary" if truth is binary, "hand_till" if truth has >2 levels and case_weights isn't specified, or "macro" if truth has >2 levels and case_weights is specified (in which case "hand_till" isn't well-defined).}

\item{na_rm}{A logical value indicating whether NA values should be stripped before the computation proceeds.}

\item{event_level}{A single string. Either "first" or "second" to specify which level of truth to consider as the "event". This argument is only applicable when estimator = "binary". The default uses an internal helper that generally defaults to "first"}

\item{case_weights}{The optional column identifier for case weights. This should be an unquoted column name that evaluates to a numeric column in data. For _vec() functions, a numeric vector.}

\item{estimate}{If truth is binary, a numeric vector of class probabilities corresponding to the "relevant" class. Otherwise, a matrix with as many columns as factor levels of truth. It is assumed that these are in the same order as the levels of truth.}
}
\value{
A tibble with columns .metric, .estimator, and .estimate and 1 row of values.
For grouped data frames, the number of rows returned will be the same as the
number of groups.
}
\description{
This function the Boyce Continuous Index, a measure of model accuracy appropriate
for Species Distribution Models with presence only data (i.e. using pseudoabsences
or background). The algorithm used here comes from the package \code{enmSdm}, and uses multiple
overlapping windows.
}
\details{
There is no multiclass version of this function, it only operates on binary
predictions (e.g. presences and absences in SDMs).
}
\examples{
boyce_cont(two_class_example, truth, Class1)

}
\references{
Boyce, M.S., P.R. Vernier, S.E. Nielsen and F.K.A. Schmiegelow. 2002.
Evaluating resource selection functions. Ecol. Model., 157, 281-300.

Hirzel, A.H., G. Le Lay, V. Helfer, C. Randin and A. Guisan. 2006.
Evaluating the ability of habitat suitability models to predict
species presences. Ecol. Model., 199, 142-152.
}
\seealso{
Other class probability metrics: 
\code{\link{kap_max}()},
\code{\link{tss_max}()}
}
\concept{class probability metrics}
