% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_stats.lm.r
\name{tidy_stats.lm}
\alias{tidy_stats.lm}
\title{Create a tidy stats data frame from an lm object}
\usage{
\method{tidy_stats}{lm}(model)
}
\arguments{
\item{model}{Output of \code{lm()}.}
}
\description{
\code{tidy_stats.lm} takes an lm object and converts the object to a tidy stats data frame.
}
\examples{
# Conduct a regression
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2, 10, 20, labels = c("Ctl","Trt"))
weight <- c(ctl, trt)

model_lm <- lm(weight ~ group)
tidy_stats(model_lm)

}
