% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct.R
\name{distinct.}
\alias{distinct.}
\alias{dt_distinct}
\title{Select distinct/unique rows}
\usage{
distinct.(.data, ..., .keep_all = FALSE)

dt_distinct(.data, ..., .keep_all = FALSE)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{Columns to select before determining uniqueness. If omitted, will use all columns.
\code{tidyselect} compatible.}

\item{.keep_all}{Only relevant if columns are provided to ... arg.
This keeps all columns, but only keeps the first row of each distinct
values of columns provided to ... arg.}
}
\description{
Retain only unique/distinct rows from an input df.
}
\examples{
example_dt <- tidytable(
  x = 1:3,
  y = 4:6,
  z = c("a", "a", "b"))

example_dt \%>\%
  distinct.()

example_dt \%>\%
  distinct.(z)
}
