% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unite.R
\name{unite.}
\alias{unite.}
\title{Unite multiple columns by pasting strings together}
\usage{
unite.(.df, col = "new_col", ..., sep = "_", remove = TRUE, na.rm = FALSE)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{col}{Name of the new column, as a string.}

\item{...}{Selection of columns. If empty all variables are selected.
\code{tidyselect} compatible.}

\item{sep}{Separator to use between values}

\item{remove}{If TRUE, removes input columns from the data.table.}

\item{na.rm}{If TRUE, NA values will be not be part of the concatenation}
}
\description{
Convenience function to paste together multiple columns into one.
}
\examples{
test_df <- tidytable(a = c("a", "a", "a"),
                     b = c("b", "b", "b"),
                     c = c("c", "c", NA))

test_df \%>\%
  unite.("new_col", b, c)

test_df \%>\%
  unite.("new_col", where(is.character))

test_df \%>\%
  unite.("new_col", b, c, remove = FALSE)

test_df \%>\%
  unite.("new_col", b, c, na.rm = TRUE)

test_df \%>\%
  unite.()
}
