% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_fill_terrain.R
\name{scale_fill_terrain}
\alias{scale_fill_terrain}
\alias{scale_fill_terrain_d}
\alias{scale_fill_terrain_c}
\alias{scale_fill_terrain_b}
\title{Terrain colour fill scales from grDevices}
\usage{
scale_fill_terrain_d(..., alpha = 1, direction = 1)

scale_fill_terrain_c(
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "colourbar"
)

scale_fill_terrain_b(
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "coloursteps"
)
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[ggplot2:discrete_scale]{discrete_scale()}},
\code{\link[ggplot2:continuous_scale]{continuous_scale()}}, or \link[ggplot2]{binned_scale} to control name, limits, breaks,
labels and so forth.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are ordered from darkest to lightest. If -1, the order of colors is reversed.}

\item{na.value}{Missing values will be replaced with this value.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
}
\value{
The corresponding ggplot2 layer with the values applied to the
\code{fill} aesthetics.
}
\description{
Implementation of the classic color palettes used by default by the
terra package (see \code{\link[terra:plot]{terra::plot()}}). Three fill scales are provided:
\itemize{
\item \code{scale_fill_terrain_d()}: For discrete values.
\item \code{scale_fill_terrain_c()}: For continuous values.
\item \code{scale_fill_terrain_b()}: For binning continuous values.
}
}
\examples{
\donttest{
filepath <- system.file("extdata/cyl_temp.tif", package = "tidyterra")


library(terra)
cyl_temp <- rast(filepath)

# Modify with tidyverse methods
library(dplyr)
continous <- cyl_temp \%>\% select(tavg_05)

library(ggplot2)
ggplot() +
  geom_spatraster(data = continous) +
  scale_fill_terrain_c()

# Binned
ggplot() +
  geom_spatraster(data = continous) +
  scale_fill_terrain_b(breaks = seq(5, 20, 2.5))

# With discrete values
factor <- continous \%>\% mutate(tavg_05 = cut(tavg_05,
  breaks = c(0, 7, 9, 11, 13, 15),
  labels = c(
    "Very Cold", "Cold", "Mild", "Hot",
    "Very Hot"
  )
))




ggplot() +
  geom_spatraster(data = factor) +
  scale_fill_terrain_d(na.value = "gray80")
}
}
\seealso{
\code{\link[terra:plot]{terra::plot()}}, \code{\link[ggplot2:scale_viridis]{ggplot2::scale_fill_viridis_c()}}

Other ggplot2 utils:
\code{\link{autoplot}()},
\code{\link{geom_spat_contour}},
\code{\link{geom_spatraster_rgb}()},
\code{\link{geom_spatraster}()},
\code{\link{ggspatvector}}
}
\concept{ggplot2.utils}
