% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_grass.R
\name{scale_grass}
\alias{scale_grass}
\alias{scale_fill_grass_d}
\alias{scale_colour_grass_d}
\alias{scale_color_grass_d}
\alias{scale_fill_grass_c}
\alias{scale_colour_grass_c}
\alias{scale_color_grass_c}
\alias{scale_fill_grass_b}
\alias{scale_colour_grass_b}
\alias{scale_color_grass_b}
\alias{grass.colors}
\title{GRASS scales}
\source{
Derived from \url{https://github.com/OSGeo/grass/tree/main/lib/gis/colors}. See
also \href{https://grass.osgeo.org/grass83/manuals/r.colors.html}{r.color - GRASS GIS Manual}.
}
\usage{
scale_fill_grass_d(
  palette = "viridis",
  ...,
  alpha = 1,
  direction = 1,
  na.translate = FALSE,
  drop = TRUE
)

scale_colour_grass_d(
  palette = "viridis",
  ...,
  alpha = 1,
  direction = 1,
  na.translate = FALSE,
  drop = TRUE
)

scale_fill_grass_c(
  palette = "viridis",
  ...,
  alpha = 1,
  direction = 1,
  values = NULL,
  limits = NULL,
  use_grass_range = TRUE,
  na.value = "transparent",
  guide = "colourbar"
)

scale_colour_grass_c(
  palette = "viridis",
  ...,
  alpha = 1,
  direction = 1,
  values = NULL,
  limits = NULL,
  use_grass_range = TRUE,
  na.value = "transparent",
  guide = "colourbar"
)

scale_fill_grass_b(
  palette = "viridis",
  ...,
  alpha = 1,
  direction = 1,
  values = NULL,
  limits = NULL,
  use_grass_range = TRUE,
  na.value = "transparent",
  guide = "coloursteps"
)

scale_colour_grass_b(
  palette = "viridis",
  ...,
  alpha = 1,
  direction = 1,
  values = NULL,
  limits = NULL,
  use_grass_range = TRUE,
  na.value = "transparent",
  guide = "coloursteps"
)

grass.colors(n, palette = "viridis", alpha = 1, rev = FALSE)
}
\arguments{
\item{palette}{A valid palette name. The name is matched to the list of
available palettes, ignoring upper vs. lower case. See
\link{grass_db} for more info.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}, \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale}}, \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale}}
  \describe{
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
breaks.
}}
    \item{\code{n.breaks}}{An integer guiding the number of major breaks. The algorithm
may choose a slightly different number to ensure nice break labels. Will
only have an effect if \code{breaks = waiver()}. Use \code{NULL} to use the default
number of breaks given by the transformation.}
    \item{\code{nice.breaks}}{Logical. Should breaks be attempted placed at nice values
instead of exactly evenly spaced between the limits. If \code{TRUE} (default)
the scale will ask the transformation object to create breaks, and this
may result in a different number of breaks than requested. Ignored if
breaks are given explicitly.}
  }}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{na.translate}{Should \code{NA} values be removed from the legend? Default
is \code{TRUE}.}

\item{drop}{Should unused factor levels be omitted from the scale? The
default (\code{TRUE}) removes unused factors.}

\item{values}{if colours should not be evenly positioned along the gradient
this vector gives the position (between 0 and 1) for each colour in the
\code{colours} vector. See \code{\link[scales:rescale]{rescale()}} for a convenience function
to map an arbitrary range to between 0 and 1.}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}

\item{use_grass_range}{Logical. Should the scale use the suggested range
when plotting? See \strong{Details}.}

\item{na.value}{Missing values will be replaced with this value. By default,
\CRANpkg{tidyterra} uses \code{na.value = "transparent"} so cells with \code{NA} are
not filled. See also
\href{https://github.com/dieghernan/tidyterra/issues/120}{#120}.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{n}{the number of colors (\eqn{\ge 1}) to be in the
    palette.}

\item{rev}{logical indicating whether the ordering of the colors should
    be reversed.}
}
\value{
The corresponding \CRANpkg{ggplot2} layer with the values applied to the
\code{fill/colour} \code{aes()}.
}
\description{
Implementation of \href{https://grass.osgeo.org/grass83/manuals/r.colors.html}{GRASS color tables}. The
following fill scales and palettes are provided:
\itemize{
\item \verb{scale_*_grass_d()}: For discrete values.
\item \verb{scale_*_grass_c()}: For continuous values.
\item \verb{scale_*_grass_b()}: For binning continuous values.
\item \code{grass.colors()}: Gradient color palette. See also
\code{\link[grDevices:palettes]{grDevices::terrain.colors()}} for details.
}

Additional parameters \code{...} would be passed on to:
\itemize{
\item Discrete values: \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.
\item Continuous values: \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.
\item Binned continuous values: \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale()}}.
}

\strong{Note that} \CRANpkg{tidyterra} just documents a selection of these
additional parameters, check the \CRANpkg{ggplot2} functions listed above to
see the full range of parameters accepted by these scales.

These palettes are an implementation of \code{\link[terra:mappal]{terra::map.pal()}}, that is the
default color palettes provided by \code{\link[terra:plot]{terra::plot()}} (\CRANpkg{terra}
\verb{> 1.7.78}).
}
\details{
Some palettes are mapped by default to a specific range of values (see
\link{grass_db}). However, it is possible to modify this behaviour with the
\code{use_grass_range} argument, When \code{FALSE} the color scales would be mapped
to the range of values of the \code{color/fill} aesthethics, See \strong{Examples}.
}
\section{\CRANpkg{terra} equivalent}{


\code{\link[terra:mappal]{terra::map.pal()}}
}

\examples{
\donttest{
filepath <- system.file("extdata/volcano2.tif", package = "tidyterra")

library(terra)
volcano2_rast <- rast(filepath)

# Palette
plot(volcano2_rast, col = grass.colors(100, palette = "haxby"))

library(ggplot2)
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_grass_c(palette = "terrain")

# Use with no default limits
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_grass_c(palette = "terrain", use_grass_range = FALSE)

# Full map with true tints

f_asia <- system.file("extdata/asia.tif", package = "tidyterra")
asia <- rast(f_asia)

ggplot() +
  geom_spatraster(data = asia) +
  scale_fill_grass_c(
    palette = "srtm_plus",
    labels = scales::label_number(),
    breaks = c(-10000, 0, 5000, 8000),
    guide = guide_colorbar(reverse = FALSE)
  ) +
  labs(fill = "elevation (m)") +
  theme(
    legend.position = "bottom",
    legend.title.position = "top",
    legend.key.width = rel(3),
    legend.ticks = element_line(colour = "black", linewidth = 0.3),
    legend.direction = "horizontal"
  )

# Binned
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_grass_b(breaks = seq(70, 200, 25), palette = "sepia")


# With discrete values
factor <- volcano2_rast \%>\%
  mutate(cats = cut(elevation,
    breaks = c(100, 120, 130, 150, 170, 200),
    labels = c(
      "Very Low", "Low", "Average", "High",
      "Very High"
    )
  ))

ggplot() +
  geom_spatraster(data = factor, aes(fill = cats)) +
  scale_fill_grass_d(palette = "soilmoisture")
}

# Display all the GRASS palettes
data("grass_db")

pals_all <- unique(grass_db$pal)

# In batches
pals <- pals_all[c(1:25)]
# Helper fun for plotting

ncols <- 128
rowcol <- grDevices::n2mfrow(length(pals))

opar <- par(no.readonly = TRUE)
par(mfrow = rowcol, mar = rep(1, 4))

for (i in pals) {
  image(
    x = seq(1, ncols), y = 1, z = as.matrix(seq(1, ncols)),
    col = grass.colors(ncols, i), main = i,
    ylab = "", xaxt = "n", yaxt = "n", bty = "n"
  )
}
par(opar)

# Second batch
pals <- pals_all[-c(1:25)]

ncols <- 128
rowcol <- grDevices::n2mfrow(length(pals))

opar <- par(no.readonly = TRUE)
par(mfrow = rowcol, mar = rep(1, 4))

for (i in pals) {
  image(
    x = seq(1, ncols), y = 1, z = as.matrix(seq(1, ncols)),
    col = grass.colors(ncols, i), main = i,
    ylab = "", xaxt = "n", yaxt = "n", bty = "n"
  )
}
par(opar)
}
\references{
GRASS Development Team (2024). \emph{Geographic Resources Analysis Support System
(GRASS) Software, Version 8.3.2}. Open Source Geospatial Foundation, USA.
\url{https://grass.osgeo.org}.
}
\seealso{
\link{grass_db}, \code{\link[terra:plot]{terra::plot()}},
\code{\link[terra:minmax]{terra::minmax()}}, \code{\link[ggplot2:scale_viridis]{ggplot2::scale_fill_viridis_c()}}.

See also \CRANpkg{ggplot2} docs on additional \code{...} parameters:

Other gradient scales and palettes for hypsometry:
\code{\link{scale_color_coltab}()},
\code{\link{scale_cross_blended}},
\code{\link{scale_hypso}},
\code{\link{scale_princess}},
\code{\link{scale_terrain}},
\code{\link{scale_whitebox}}
}
\concept{gradients}
