% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-extract-BART.R
\name{posterior_trees_BART}
\alias{posterior_trees_BART}
\title{Get posterior tree draws into tibble format from BART model}
\usage{
posterior_trees_BART(model, label_digits = 2)
}
\arguments{
\item{model}{BART model.}

\item{label_digits}{Rounding for labels.}
}
\value{
A tibble with columns to \describe{
  \item{iter}{Integer describing unique MCMC iteration.}
  \item{tree_id}{Integer. Unique tree id with each `iter`.}
  \item{node}{Integer describing node in tree. Unique to each `tree`-`iter`.}
  \item{parent}{Integer describing parent node in tree.}
  \item{label}{Label for the node.}
  \item{tier}{Position in tree hierarchy.}
  \item{var}{Variable for split.}
  \item{cut}{Numeric. Value of decision rule for `var`.}
  \item{is_leaf}{Logical. `TRUE` if leaf, `FALSE` if stem.}
  \item{leaf_value}{}
  \item{child_left}{Integer. Left child of node.}
  \item{child_right}{Integer. Right child of node.}
  }
}
\description{
Tibble grouped by iteration (`iter`) and tree id (`tree_id`). All information
  calculated by method is included in output.
}
