% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostiscs-tsfeatures.R
\name{tk_tsfeatures}
\alias{tk_tsfeatures}
\title{Time series feature matrix (Tidy)}
\usage{
tk_tsfeatures(
  .data,
  .date_var,
  .value,
  .period = "auto",
  .features = c("frequency", "stl_features", "entropy", "acf_features"),
  .scale = TRUE,
  .trim = FALSE,
  .trim_amount = 0.1,
  .parallel = FALSE,
  .na_action = na.pass,
  .prefix = "ts_",
  .silent = TRUE,
  ...
)
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} with a time-based column}

\item{.date_var}{A column containing either date or date-time values}

\item{.value}{A column containing numeric values}

\item{.period}{The periodicity (frequency) of the time series data. Values can be provided as follows:
\itemize{
\item "auto" (default) Calculates using \code{tk_get_frequency()}.
\item "2 weeks": Would calculate the median number of observations in a 2-week window.
\item 7 (numeric): Would interpret the \code{ts} frequency as 7 observations per cycle (common for weekly data)
}}

\item{.features}{Passed to \code{features} in the underlying \code{tsfeatures()} function.
A vector of function names that represent a feature aggregation function. Examples:
\enumerate{
\item Use one of the function names from \code{tsfeatures} R package e.g.("lumpiness", "stl_features").
\item Use a function name (e.g. "mean" or "median")
\item Create your own function and provide the function name
}}

\item{.scale}{If \code{TRUE}, time series are scaled to mean 0 and sd 1 before features are computed.}

\item{.trim}{If \code{TRUE}, time series are trimmed by trim_amount before features are computed.
Values larger than trim_amount in absolute value are set to \code{NA}.}

\item{.trim_amount}{Default level of trimming if trim==TRUE. Default: 0.1.}

\item{.parallel}{If TRUE, multiple cores (or multiple sessions) will be used.
This only speeds things up when there are a large number of time series.

When \code{.parallel = TRUE}, the \code{multiprocess = future::multisession}.
This can be adjusted by setting \code{multiprocess} parameter.
See the \code{tsfeatures::tsfeatures()} function for mor details.}

\item{.na_action}{A function to handle missing values. Use na.interp to estimate missing values.}

\item{.prefix}{A prefix to prefix the feature columns. Default: \code{"ts_"}.}

\item{.silent}{Whether or not to show messages and warnings.}

\item{...}{Other arguments get passed to the feature functions.}
}
\value{
A \code{tibble} or \code{data.frame} with aggregated features that describe each time series.
}
\description{
\code{tk_tsfeatures()} is a tidyverse compliant wrapper for \code{tsfeatures::tsfeatures()}.
The function computes a matrix of time series features that describes the various time
series. It's designed for groupwise analysis using \code{dplyr} groups.
}
\details{
The \code{timetk::tk_tsfeatures()} function implements the \code{tsfeatures} package
for computing aggregated feature matrix for time series that is useful in many types of
analysis such as clustering time series.

The \code{timetk} version ports the \code{tsfeatures::tsfeatures()} function to a \code{tidyverse}-compliant
format that uses a tidy data frame containing grouping columns (optional), a date column, and
a value column. Other columns are ignored.

It then becomes easy to summarize each time series by group-wise application of \code{.features},
which are simply functions that evaluate a time series and return single aggregated value.
(Example: "mean" would return the mean of the time series (note that values are scaled to mean 1 and sd 0 first))

\strong{Function Internals:}

Internally, the time series are converted to \code{ts} class using \code{tk_ts(.period)} where the
period is the frequency of the time series. Values can be provided for \code{.period}, which will be used
prior to convertion to \code{ts} class.

The function then leverages \code{tsfeatures::tsfeatures()} to compute the feature matrix of summarized
feature values.
}
\examples{
library(dplyr)
library(timetk)

walmart_sales_weekly \%>\%
    group_by(id) \%>\%
    tk_tsfeatures(
      .date_var = Date,
      .value    = Weekly_Sales,
      .period   = 52,
      .features = c("frequency", "stl_features", "entropy", "acf_features", "mean"),
      .scale    = TRUE,
      .prefix   = "ts_"
    )

}
\references{
\enumerate{
\item Rob Hyndman, Yanfei Kang, Pablo Montero-Manso, Thiyanga Talagala, Earo Wang, Yangzhuoran Yang,
Mitchell O'Hara-Wild: tsfeatures R package
}
}
