% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord_reg.R
\name{ordered-regular}
\alias{ordered-regular}
\alias{is.ordered_t}
\alias{is.ordered_t.tind}
\alias{is.regular}
\alias{is.regular.tind}
\alias{as.regular}
\alias{as.regular.tind}
\alias{extend_regular}
\title{Working with Ordered and Regularly Spaced Time Indices}
\usage{
is.ordered_t(x)

\method{is.ordered_t}{tind}(x)

is.regular(x)

\method{is.regular}{tind}(x)

as.regular(x, ...)

\method{as.regular}{tind}(x, ...)

extend_regular(x, n)
}
\arguments{
\item{x}{an object of \code{tind} class or of other time index class
supported by \pkg{tind} package.}

\item{...}{further arguments passed to or from other methods.}

\item{n}{an integer value, number of time stamps to be added, see Details.}
}
\value{
A logical value for \code{is.ordered_t} and \code{is.regular}.
An object of \code{tind} class for \code{as.regular} and \code{extend_regular}.
}
\description{
\code{is.ordered_t} method checks if time indices form a strictly
increasing sequence without \code{NA} values.

\code{is.regular} method checks if time indices form a strictly
increasing, regularly spaced sequence without \code{NA} values.

\code{as.regular} returns regularly spaced sequence of time
indices based on strictly increasing time indices provided.

\code{extend_regular} extends strictly increasing sequence of time indices
by \code{n} points after the last taking into account the resolution
of the sequence provided.
}
\details{
\code{n} argument of \code{extend_regular} can be negative. In that case
\code{-n} points are added before the first index. The function may
fail in corner cases (if the result would be out of range).

Creating regular date-time sequences in front of DST/UTC offset changes
can be impossible. If the algorithm fails, an error is issued. In general,
this should not be a problem when DST change is by 1 hour and the resolution
of the indices is 1 hour or higher.
}
\examples{
# months, resulution 2m
(ms <- tind(y = 2023, m = 1 + 2 * (0:5)))
is.regular(ms)
extend_regular(ms, 3)
(ms <- tind(y = 2023, m = c(1, 3, 5, 9)))
is.regular(ms)
as.regular(ms)
# date, resulution 15d
(ds <- tind(y = 2024, m = rep(1:3, each = 2), d = c(1, 16)))
is.regular(ds)
extend_regular(ds, -4)
(ds <- ds[-2L])
is.regular(ds)
as.regular(ds)

# corner cases
tz <- "Europe/Warsaw"
if (tz \%in\% OlsonNames()) {
    # switch to DST
    print(hours_in_day("2025-03-30", tz = tz))
    # this will work with step from 1am to 3am
    tt <- date_time("2025-03-30", H = c(0, 4:8), tz = tz)
    print(resolution_t(tt))
    as.regular(tt)
}
if (tz \%in\% OlsonNames()) {
    # this will fail due to missing 2am
    tt <- date_time("2025-03-30", H = c(0, 4, 6, 8), tz = tz)
    print(resolution_t(tt))
    try(as.regular(tt))
}
if (tz \%in\% OlsonNames()) {
    # this will work again (step by 4h)
    tt <- date_time("2025-03-30", H = c(0, 4, 12), tz = tz)
    print(resolution_t(tt))
    as.regular(tt)
}

}
\seealso{
\code{\link{resolution_t}} method.
}
