library(tlnise)

## Check output of tlnise

set.seed(2034)
x <- rnorm(10)  ## Second level
y <- rnorm(10, x)  ## First level means

initTLNise()
out <- tlnise(Y = y, V = rep(1, 10), w = rep(1, 10), seed = 1234)

str(out)


######################################################################
## MCAPS estimates for heart failure

b <- c(0.00149396583566524, -0.00292977126891265, 0.0121904633496598, 
       -0.000802309376520131, 0.000742083941980712, -0.00931880699849618, 
       -0.000544399553131178, 0.00433490190888971, 0.00862692937466076, 
       -0.00134918513270739, 0.000775791002417968, -0.000241284735975443, 
       0.00193307106007087, 0.0011808645945406, 0.000123119976100465, 
       0.00286955585374515, 0.00215849825743017, -0.00183790195560519, 
       0.00393985296531518, 0.00196559576224305, 0.000523608410658433, 
       0.00866862062967869, 0.0129355060859846, 0.010348018969562, 0.0104026574521019, 
       -0.00091739090575703, 0.00475623797052342, 0.00092264798225817, 
       0.000102100113938734, 0.00728093280924615, -0.00219993501561538, 
       0.00125620434631363, -0.00444708606417238, 0.00210975891211224, 
       0.00391351849704126, -0.00914263288233904, -0.0148740906004851, 
       0.00141188876533933, -0.00317069002007167, 0.00223573810682327, 
       -0.00151830284659824, -0.00218753844078927, 0.00129619231478152, 
       -0.0182757313976321, 0.0282660496621266, 0.000598624310765048, 
       0.00113074843174785, 0.00397320927938413, -0.000683136631184895, 
       0.00039902561634341, -0.000852792120828147, 0.00288950436558834, 
       -0.00070895168498173, 0.0196478546892163, -0.00921042279714225, 
       0.00573337323900105, 0.00486203900308959, -0.00689076246188992, 
       0.000319877616657825, 0.00205074246109843, -0.000432577252864018, 
       -0.0041501059384509, -0.011042421690307, 0.0120147911358616, 
       -0.000978041500498144, 0.00239964507382367, 0.00494311029551287, 
       0.00178067095737446, -0.00607781865239217, 0.00655348424672004, 
       0.0129647907827897, 0.00279563305226242, 0.000332101873199826, 
       -0.00072309398459047, 0.0122046571906774, -0.00182842156745787, 
       0.00190582747758865, 0.00197495874277356, -0.00283397601339165, 
       0.0016310785576648, -0.00381252063814762, 0.0078575828417826, 
       0.00190695201342577, 0.00180514351281873, -0.0065171355335707, 
       -0.0107218623889581, 0.000513988510977037, 0.00632622404097398, 
       -0.000478693153924546, 0.00105673210553345, -0.0118185286688077, 
       -0.00139332788645963, 0.00188911253815622, -0.0095446494769887, 
       -0.00132339106509484, 0.00183940382555188, -0.0137453735619853, 
       -0.00602299318404974, -0.00137445425824164, -0.00461032619213651, 
       0.00380445971936237, 0.000385123494320079, 0.0187473281901191, 
       -0.0194283545060805, 0.00033369990167219, 0.00437820546280211, 
       0.00381453975278387, 0.00216423414027038, 0.00672214539038485, 
       0.00649434358066091, 0.00561681185139901, 0.00848370128343284, 
       0.00771483669226333, 0.00142337281441747, -0.0147615237205868, 
       0.000431406660146463, 0.00384462668585289, -0.0145414317880864, 
       0.00514886971011905, -0.000653957954222004, -0.0214390779614198, 
       0.00388324369857205, 0.00182243006478132, 0.00756281798882078, 
       -0.0161750116952278, -0.00199476985514211, 0.00653741290644234, 
       0.00647690665498052, 0.00521029879923854, -0.000644816095584337, 
       0.0052848831848841, 0.00190394942246647, -0.00000576579369568543, 
       0.00200133216801802, 0.00458621344151802, -0.000158519544412821, 
       -0.000811347289422067, 0.000828196618611728, 0.000637763912390868, 
       -0.000450748665166619, 0.00447917177946726, 0.00155447902806828, 
       0.00271616626704262, -0.00259897005709888, 0.00191973103832381, 
       0.00241806685396262, -0.000843959343762298, -0.00607265201487205, 
       0.00263560032652509, 0.00830487027062904, -0.0040017439296613, 
       0.00554188735682682, 0.0116054020166001, -0.00093776736602915, 
       -0.00157459989265931, 0.0159654250888899, 0.000265849376179199, 
       0.00290159178928047, 0.00136343676329553, -0.00381882072478883, 
       -0.00278394187976723, 0.0072443913987279, -0.0008714923145472, 
       -0.00440784969007088, 0.00503020901070174, 0.00307659358543293, 
       0.000815584693053195, -0.00167766760169622, 0.00091240731656494, 
       0.00150641208727891, -0.0024982940272427, -0.00188463669156617, 
       0.00301319344779174, -0.00114251137275521, 0.0156655440318821, 
       0.00756489183645519, 0.00195102735099252, 0.00398633356676512, 
       0.00616071842607807, 0.00126903471605487, 0.0139985915669846, 
       -0.00173378085609806, -0.00409726722190573, 0.0000919288709540982, 
       -0.0156140589471326, 0.0038998667102483, -0.000255601909650388, 
       0.0147215549189127, 0.00168593793531953, 0.00142870942259815, 
       0.00483020400729826, 0.0169861637755693, -0.0237416622523685, 
       0.0019640948837047, 0.00505926622095891, -0.00374713945593113, 
       -0.014805684041516, 0.000463054350922498, 0.00911650950202501, 
       -0.00320044704639911, 0.00178525474609749, 0.00028676310697451
       )

v <- c(0.00000399680511659135, 0.0000424254252945438, 0.0000338306371059458, 
       0.0000442416850698535, 0.0000072504634884262, 0.0000789743433363075, 
       0.000012092335105302, 0.0000118515719777804, 0.0000094696290941654, 
       0.00000186273528402906, 0.00000226567876937098, 0.000000354681856491901, 
       0.0000144411373800842, 0.00000455973753102972, 0.0000142696784941877, 
       0.00000327355940625098, 0.00000653476574786794, 0.0000147267280371197, 
       0.0000460826817139496, 0.00000567711342475643, 0.0000174951380463848, 
       0.000193499511507789, 0.00004727470189757, 0.0000290175230512107, 
       0.00000873317553687791, 0.00000573706113668087, 0.00000468930619047718, 
       0.00000488608860667065, 0.00000469886496846548, 0.000118711593672572, 
       0.00000614542285021862, 0.0000104720306197029, 0.0000521104850929415, 
       0.00000914410359509285, 0.0000746494842630015, 0.000146549907347209, 
       0.0000618107241511498, 0.00000433044619543979, 0.0000103909653016202, 
       0.00000717031108080367, 0.00000526164288577415, 0.000131248782511176, 
       0.0000431568053139928, 0.000051177607687242, 0.0000731859078680652, 
       0.0000323432967218256, 0.00000780465979951746, 0.00000417209550180024, 
       0.0000426829039965877, 0.000000662038720106208, 0.000021587179544658, 
       0.0000580063267649112, 0.0000365350538156817, 0.0000734265004016465, 
       0.0000732583219715163, 0.0000344888652639462, 0.0000244527476344056, 
       0.000044680837893312, 0.0000408186570638078, 0.00000414032694031985, 
       0.0000450212398008783, 0.0000183406009018638, 0.0000692367342892051, 
       0.0000411620630201476, 0.0000610954622199966, 0.00000358588184398529, 
       0.000032711586177277, 0.0000177597254874703, 0.0000121074651959021, 
       0.00000983387609300587, 0.0000544360294496804, 0.0000261112383600638, 
       0.00000493830621061009, 0.0000283788507181375, 0.0000232839183573953, 
       0.0000144993127798981, 0.0000183158169674426, 0.0000157654040387268, 
       0.0000093005211690951, 0.000012968032058572, 0.0000258721310162204, 
       0.0000371978095757873, 0.0000066303058985596, 0.0000133117021559566, 
       0.0000250100504578792, 0.000057597434315499, 0.00000844742980728479, 
       0.0000240459840667066, 0.0000150137158944987, 0.0000650487007029704, 
       0.000117540551099041, 0.0000685855722663892, 0.00000114616377497155, 
       0.000197592218137949, 0.0000118543491367597, 0.0000181152924848789, 
       0.00016267923380552, 0.0000699519773236483, 0.0000084157907929102, 
       0.0000385037413342477, 0.0000190510833419068, 0.0000084976788334423, 
       0.0000616433054471884, 0.0000697083572306896, 0.00010098654441886, 
       0.00000851052202420252, 0.0000131813718078581, 0.00000817064415342047, 
       0.0000291933142232431, 0.000024654910904144, 0.0000136384151684996, 
       0.0000268925554544376, 0.0000200198815275698, 0.00000609313791997675, 
       0.000123780593578965, 0.0000462276310020324, 0.00000358941353425704, 
       0.000113094364160512, 0.000013221140470382, 0.00000550828396301089, 
       0.0000555162388336628, 0.00000921847178750176, 0.00000416468246072854, 
       0.0000679005388032652, 0.000103773943782275, 0.0000437531246471874, 
       0.00000461453818824125, 0.0000332562710825616, 0.0000107476659499646, 
       0.000018013117522366, 0.0000383957924772044, 0.0000290049622735936, 
       0.0000152742779574256, 0.0000120174816932366, 0.000006997601939648, 
       0.0000105893800927236, 0.0000139362411241415, 0.00000103444662989601, 
       0.00000246420402751228, 0.00000338276126273624, 0.000047020970159019, 
       0.0000342697061825726, 0.00000722301330226111, 0.00000819617545153257, 
       0.00000522818595475649, 0.0000212659352600957, 0.00000470954921116541, 
       0.00000934544558748913, 0.00000913065013145942, 0.0000125508908195071, 
       0.0000362117267121494, 0.0000274781233989739, 0.000153447073779394, 
       0.00000104724870193257, 0.0000205276927290734, 0.0000762816955172774, 
       0.0000131892603906333, 0.0000125215762672593, 0.0000295914791240131, 
       0.0000092233253429713, 0.0000367164860817044, 0.00000716187070752949, 
       0.0000141726824842192, 0.0000255413531241739, 0.00000732423543698972, 
       0.0000136143062386779, 0.0000100061066908583, 0.00007396666694681, 
       0.000036345335914458, 0.0000160499835570513, 0.0000091582848270696, 
       0.0000067592710650662, 0.00000376106378770419, 0.0000136028956010947, 
       0.0000951316207730493, 0.000118711049784257, 0.00000369147613889987, 
       0.0000123840437671186, 0.0000425653392791316, 0.00000269072955759726, 
       0.0000435106424786549, 0.0000187989839611951, 0.000136949591080194, 
       0.00012654291325847, 0.0000897559990817051, 0.0000072865200790039, 
       0.0000187806813400272, 0.000105615360625357, 0.00000509191122546219, 
       0.0000148438880208707, 0.0000784365931708921, 0.0000718970628086317, 
       0.000157298195439872, 0.00000581272450040291, 0.0000095945906237973, 
       0.0000255515487742222, 0.000136705975901061, 0.000029206310588846, 
       0.0000645513206998557, 0.0000561506094444819, 0.00000327007445922052, 
       0.000016034211707281)

initTLNise()
out <- tlnise(b, v, seed = 435235)

str(out)

out$gamma  ## 'est' should be about 0.00128

######################################################################
