% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SummariesModelClass.R
\docType{class}
\name{ContinSummaryModel}
\alias{ContinSummaryModel}
\title{R6 class for fitting and predicting joint probability for a univariate continuous summary measure sA[j]}
\format{An \code{\link{R6Class}} generator object}
\usage{
ContinSummaryModel
}
\description{
This R6 class defines and fits a conditional probability model \code{P(sA[j]|sW,...)} for a univariate
 continuous summary measure \code{sA[j]}. This class inherits from \code{\link{SummariesModel}} class.
 Defines the fitting algorithm for a regression model \code{sA[j] ~ sW + ...}.
 Reconstructs the likelihood \code{P(sA[j]=sa[j]|sW,...)} afterwards.
 Continuous \code{sA[j]} is discretized using either of the 3 interval cutoff methods,
 defined via \code{\link{RegressionClass}} object \code{reg} passed to this class constructor.
 The fitting algorithm estimates the binary regressions for hazard \code{Bin_sA[j][i] ~ sW},
 i.e., the probability that continuous \code{sA[j]} falls into bin \code{i}, \code{Bin_sA[j]_i},
 given that \code{sA[j]} does not belong to any prior bins \code{Bin_sA[j]_1, ..., Bin_sA[j]_{i-1}}.
 The dataset of discretized summary measures (\code{BinsA[j]_1,...,BinsA[j]_M}) is created
 inside the passed \code{data} or \code{newdata} object while discretizing \code{sA[j]} into \code{M} bins.
}
\details{
\itemize{
\item{\code{reg}} - .
\item{\code{outvar}} - .
\item{\code{intrvls}} - .
\item{\code{intrvls.width}} - .
\item{\code{bin_weights}} - .
}
}
\section{Methods}{

\describe{
  \item{\code{new(reg, DatNet.sWsA.g0, DatNet.sWsA.gstar, ...)}}{...}
  \item{\code{fit(data)}}{...}
  \item{\code{predict(newdata)}}{...}
  \item{\code{predictAeqa(newdata)}}{...}
}
}

\section{Active Bindings}{

\describe{
  \item{\code{cats}}{...}
}
}
\keyword{R6}
\keyword{class}

