% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rtmvt}
\alias{rtmvt}
\title{Random Generation for Truncated Multivariate t}
\usage{
rtmvt(mean, sigma, nu, blc, lower, upper, init, burn = 10L)
}
\arguments{
\item{mean}{\code{n x p} matrix of means. The number of rows is the number 
of observations. The number of columns is the dimension of the problem.}

\item{sigma}{\code{p x p} covariance matrix.}

\item{nu}{degrees of freedom for Student-t distribution.}

\item{blc}{\code{m x p} matrix of coefficients for linear inequality 
constraints.}

\item{lower}{\code{n x m} or \code{1 x m} matrix of lower bounds for 
truncation.}

\item{upper}{\code{n x m} or \code{1 x m} matrix of upper bounds for 
truncation.}

\item{init}{\code{n x p} or \code{1 x p} matrix of initial values.}

\item{burn}{Number of burn-in iterations. Defaults to 10.}
}
\value{
Returns a \code{n x p} matrix of random numbers following the 
  specified truncated multivariate t distribution.
}
\description{
Draws from truncated multivariate t distribution subject to 
linear inequality constraints represented by a matrix.
}
\examples{
# Example 1: full rank
d = 3;
rho = 0.5;
nu = 10;
sigma = matrix(0, d, d);
sigma = rho^abs(row(sigma) - col(sigma));
blc = diag(1,d);
n = 1000;
mean = matrix(rep(1:d,n), nrow=n, ncol=d, byrow=TRUE);
lower = matrix(rep(-1,d), nrow=1);
upper = matrix(rep(1,d), nrow=1);
init = matrix(rep(0.8,d), nrow=1);
set.seed(1203)
result = rtmvt(mean, sigma, nu, blc, lower, upper, init, burn=50)
apply(result, 2, summary)

# Example 2: non-full rank, different means
d = 3;
rho = 0.5;
sigma = matrix(0, d, d);
sigma = rho^abs(row(sigma) - col(sigma));
nu = 10;
blc = matrix(c(1,0,1,1,1,0),nrow=d-1,ncol=d,byrow=TRUE)
n = 100;
set.seed(3084)
mean = matrix(runif(n*d), nrow=n, ncol=d);
lower = matrix(rep(-1,d-1), nrow=1);
upper = matrix(rep(1,d-1), nrow=1);
init = matrix(rep(0.8,d), nrow=1);
result = rtmvt(mean, sigma, nu, blc, lower, upper, init, burn=50)
apply(result, 2, summary)

}
