% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{navigation_options}
\alias{navigation_options}
\title{Options for buttons displayed above calendar}
\usage{
navigation_options(
  today_label = "Today",
  prev_label = ph("caret-left"),
  next_label = ph("caret-right"),
  class = "bttn-bordered bttn-sm bttn-primary",
  bg = NULL,
  color = NULL,
  fmt_date = "YYYY-MM-DD",
  sep_date = " ~ "
)
}
\arguments{
\item{today_label}{Text to display on today button.}

\item{prev_label}{Text to display on prev button.}

\item{next_label}{Text to display on next button.}

\item{class}{Class to add to buttons.}

\item{bg, color}{Background and text colors.}

\item{fmt_date}{Format for the date displayed next to the buttons,
use dayjs library (see https://day.js.org/docs/en/display/format).}

\item{sep_date}{Separator to use between start date and end date.}
}
\value{
a \code{list}.
}
\description{
Options for buttons displayed above calendar
}
\note{
Buttons are generated with the following CSS library : http://bttn.surge.sh/,
where you can find available options for \code{class} argument.
}
\examples{
# Use another button style
calendar(
  navigation = TRUE,
  navOpts = navigation_options(
    class = "bttn-stretch bttn-sm bttn-warning"
  )
)

# Custom colors (background and text)
calendar(
  navigation = TRUE,
  navOpts = navigation_options(bg = "#FE2E2E", color = "#FFF")
)

# both
calendar(
  navigation = TRUE,
  navOpts = navigation_options(
    bg = "#04B431", color = "#FFF",
    class = "bttn-float bttn-md"
  )
)


# Change date format and separator
calendar(
  navigation = TRUE,
  navOpts = navigation_options(
    fmt_date = "DD/MM/YYYY",
    sep_date = " - "
  )
)
}
