% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordcount.R
\name{count_words}
\alias{count_words}
\alias{count_characters}
\alias{count_sentences}
\title{Count words, sentences, characters}
\usage{
count_words(x)

count_characters(x)

count_sentences(x)
}
\arguments{
\item{x}{A character vector or a list of character vectors. If \code{x} is a
character vector, it can be of any length, and each element will be
tokenized separately. If \code{x} is a list of character vectors, each
element of the list should have a length of 1.}
}
\value{
An integer vector containing the counted elements. If the input
  vector or list has names, they will be preserved.
}
\description{
Count words, sentences, and characters in input texts. These functions use
the \code{stringi} package, so they handle the counting of Unicode strings
(e.g., characters with diacritical marks) in a way that makes sense to people
counting characters.
}
\examples{
count_words(mobydick)
count_sentences(mobydick)
count_characters(mobydick)
}
