% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolbox.R
\name{combineCols}
\alias{combineCols}
\title{Combine columns of a list/data frame into a list by row}
\usage{
combineCols(x, cols = NULL, by_name = FALSE, parallel = FALSE, cores = 1)
}
\arguments{
\item{x}{A list or data frame.}

\item{cols}{An optional vector of column positions or names to combine together. If passing column names, set by_name to TRUE.
The order of items in cols determines the order of the combined result.}

\item{by_name}{Boolean, if TRUE, it quotes the items in cols to properly index the list by name (x[[1]] vs x[["col_a"]]).}

\item{parallel}{Boolean, if TRUE, attempts to use mclapply.}

\item{cores}{An integer, the number of cores to use if parallel is TRUE.}
}
\value{
A list of the values in each column combined together for each row.
}
\description{
Combine columns of a list/data frame into a list by row
}
\examples{
combineCols(list("x" = c(1, 2, 3), "y" = c("a", "b", "c")))
}
