% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-fold.R
\name{nnf_unfold}
\alias{nnf_unfold}
\title{Unfold}
\usage{
nnf_unfold(input, kernel_size, dilation = 1, padding = 0, stride = 1)
}
\arguments{
\item{input}{the input tensor}

\item{kernel_size}{the size of the sliding blocks}

\item{dilation}{a parameter that controls the stride of elements within the
neighborhood. Default: 1}

\item{padding}{implicit zero padding to be added on both sides of input.
Default: 0}

\item{stride}{the stride of the sliding blocks in the input spatial dimensions.
Default: 1}
}
\description{
Extracts sliding local blocks from an batched input tensor.
}
\section{Warning}{


Currently, only 4-D input tensors (batched image-like tensors) are
supported.



More than one element of the unfolded tensor may refer to a single
memory location. As a result, in-place operations (especially ones that
are vectorized) may result in incorrect behavior. If you need to write
to the tensor, please clone it first.
}

