% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-activation.R
\name{nnf_softplus}
\alias{nnf_softplus}
\title{Softplus}
\usage{
nnf_softplus(input, beta = 1, threshold = 20)
}
\arguments{
\item{input}{(N,*) tensor, where * means, any number of additional
dimensions}

\item{beta}{the beta value for the Softplus formulation. Default: 1}

\item{threshold}{values above this revert to a linear function. Default: 20}
}
\description{
Applies element-wise, the function \eqn{Softplus(x) = 1/\beta * log(1 + exp(\beta * x))}.
}
\details{
For numerical stability the implementation reverts to the linear function
when \eqn{input * \beta > threshold}.
}
