% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creation-ops.R, R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_full_like}
\alias{torch_full_like}
\title{Full_like}
\usage{
torch_full_like(
  input,
  fill_value,
  dtype = NULL,
  layout = NULL,
  device = NULL,
  requires_grad = FALSE,
  memory_format = torch_preserve_format()
)
}
\arguments{
\item{input}{(Tensor) the size of \code{input} will determine size of the output tensor.}

\item{fill_value}{the number to fill the output tensor with.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned Tensor.        Default: if \code{NULL}, defaults to the dtype of \code{input}.}

\item{layout}{(\code{torch.layout}, optional) the desired layout of returned tensor.        Default: if \code{NULL}, defaults to the layout of \code{input}.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{NULL}, defaults to the device of \code{input}.}

\item{requires_grad}{(bool, optional) If autograd should record operations on the        returned tensor. Default: \code{FALSE}.}

\item{memory_format}{(\code{torch.memory_format}, optional) the desired memory format of        returned Tensor. Default: \code{torch_preserve_format}.}
}
\description{
Full_like
}
\section{full_like(input, fill_value, out=NULL, dtype=NULL, layout=torch.strided, device=NULL, requires_grad=False, }{


memory_format=torch.preserve_format) -> Tensor

Returns a tensor with the same size as \code{input} filled with \code{fill_value}.
\code{torch_full_like(input, fill_value)} is equivalent to
\code{torch_full(input.size(), fill_value, dtype=input.dtype, layout=input.layout, device=input.device)}.
}

