% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_multilabel_margin_loss}
\alias{nn_multilabel_margin_loss}
\title{Multilabel margin loss}
\usage{
nn_multilabel_margin_loss(reduction = "mean")
}
\arguments{
\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed. Note: \code{size_average}
and \code{reduce} are in the process of being deprecated, and in the meantime,
specifying either of those two args will override \code{reduction}. Default: \code{'mean'}}
}
\description{
Creates a criterion that optimizes a multi-class multi-classification
hinge loss (margin-based loss) between input \eqn{x} (a 2D mini-batch \code{Tensor})
and output \eqn{y} (which is a 2D \code{Tensor} of target class indices).
For each sample in the mini-batch:
}
\details{
\deqn{
  \mbox{loss}(x, y) = \sum_{ij}\frac{\max(0, 1 - (x[y[j]] - x[i]))}{\mbox{x.size}(0)}
}

where \eqn{x \in \left\{0, \; \cdots , \; \mbox{x.size}(0) - 1\right\}}, \
\eqn{y \in \left\{0, \; \cdots , \; \mbox{y.size}(0) - 1\right\}}, \
\eqn{0 \leq y[j] \leq \mbox{x.size}(0)-1}, \
and \eqn{i \neq y[j]} for all \eqn{i} and \eqn{j}.
\eqn{y} and \eqn{x} must have the same size.

The criterion only considers a contiguous block of non-negative targets that
starts at the front.
This allows for different samples to have variable amounts of target classes.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(C)} or \eqn{(N, C)} where \code{N} is the batch size and \code{C}
is the number of classes.
\item Target: \eqn{(C)} or \eqn{(N, C)}, label targets padded by -1 ensuring same shape as the input.
\item Output: scalar. If \code{reduction} is \code{'none'}, then \eqn{(N)}.
}
}

\examples{
if (torch_is_installed()) {
loss <- nn_multilabel_margin_loss()
x <- torch_tensor(c(0.1, 0.2, 0.4, 0.8))$view(c(1,4))
# for target y, only consider labels 4 and 1, not after label -1
y <- torch_tensor(c(4, 1, -1, 2), dtype = torch_long())$view(c(1,4))
loss(x, y)

}
}
