% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_torch_from_file}
\alias{install_torch_from_file}
\title{Install Torch from files}
\usage{
install_torch_from_file(
  version = "1.12.1",
  type = install_type(version = version),
  libtorch,
  liblantern,
  ...
)
}
\arguments{
\item{version}{The Torch version to install.}

\item{type}{The installation type for Torch. Valid values are \code{"cpu"} or the 'CUDA' version.}

\item{libtorch}{The installation archive file to use for Torch. Shall be a \code{"file://"} URL scheme.}

\item{liblantern}{The installation archive file to use for Lantern. Shall be a \code{"file://"} URL scheme.}

\item{...}{other parameters to be passed to \code{"install_torch()"}}
}
\description{
Installs Torch and its dependencies from files.
}
\details{
When \code{"install_torch()"} initiated download is not possible, but installation archive files are
present on local filesystem, \code{"install_torch_from_file()"} can be used as a workaround to installation issue.
\code{"libtorch"} is the archive containing all torch modules, and \code{"liblantern"} is the C interface to libtorch
that is used for the R package. Both are highly dependent, and should be checked through \code{"get_install_libs_url()"}
}
