% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{transform_spectrogram}
\alias{transform_spectrogram}
\title{Spectrogram}
\usage{
transform_spectrogram(
  n_fft = 400,
  win_length = NULL,
  hop_length = NULL,
  pad = 0L,
  window_fn = torch::torch_hann_window,
  power = 2,
  normalized = FALSE,
  ...
)
}
\arguments{
\item{n_fft}{(integer): Size of FFT}

\item{win_length}{(integer): Window size}

\item{hop_length}{(integer): Length of hop between STFT windows}

\item{pad}{(integer): Two sided padding of signal}

\item{window_fn}{(tensor or function): Window tensor that is applied/multiplied to each
frame/window or a function that generates the window tensor.}

\item{power}{(numeric): Exponent for the magnitude spectrogram, (must be > 0) e.g.,
1 for energy, 2 for power, etc. If NULL, then the complex spectrum is returned instead.}

\item{normalized}{(logical): Whether to normalize by magnitude after stft}

\item{...}{(optional) Arguments for window function.}
}
\value{
tensor: Dimension (..., freq, time), freq is n_fft \%/\% 2 + 1 and n_fft is the
number of Fourier bins, and time is the number of window hops (n_frame).
}
\description{
Create a spectrogram or a batch of spectrograms from a raw audio signal.
The spectrogram can be either magnitude-only or complex.
}
\details{
forward param:
waveform (tensor): Tensor of audio of dimension (..., time)
}
