% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms-generics.R
\name{transform_random_perspective}
\alias{transform_random_perspective}
\title{Random perspective transformation of an image with a given probability}
\usage{
transform_random_perspective(
  img,
  distortion_scale = 0.5,
  p = 0.5,
  interpolation = 2,
  fill = 0
)
}
\arguments{
\item{img}{A \code{magick-image}, \code{array} or \code{torch_tensor}.}

\item{distortion_scale}{(float): argument to control the degree of distortion
and ranges from 0 to 1. Default is 0.5.}

\item{p}{(float): probability of the image being transformed. Default is 0.5.}

\item{interpolation}{(int, optional) Desired interpolation. An integer
\code{0 = nearest}, \code{2 = bilinear}, and \code{3 = bicubic} or a name from
\code{\link[magick:options]{magick::filter_types()}}.}

\item{fill}{(int or str or tuple): Pixel fill value for constant fill.
Default is 0. If a tuple of length 3, it is used to fill R, G, B channels
respectively. This value is only used when the padding_mode is constant.
Only int value is supported for Tensors.}
}
\description{
Performs a random perspective transformation of the given image with a given
probability
}
\seealso{
Other transforms: 
\code{\link{transform_adjust_brightness}()},
\code{\link{transform_adjust_contrast}()},
\code{\link{transform_adjust_gamma}()},
\code{\link{transform_adjust_hue}()},
\code{\link{transform_adjust_saturation}()},
\code{\link{transform_affine}()},
\code{\link{transform_center_crop}()},
\code{\link{transform_color_jitter}()},
\code{\link{transform_convert_image_dtype}()},
\code{\link{transform_crop}()},
\code{\link{transform_five_crop}()},
\code{\link{transform_grayscale}()},
\code{\link{transform_hflip}()},
\code{\link{transform_linear_transformation}()},
\code{\link{transform_normalize}()},
\code{\link{transform_pad}()},
\code{\link{transform_perspective}()},
\code{\link{transform_random_affine}()},
\code{\link{transform_random_apply}()},
\code{\link{transform_random_choice}()},
\code{\link{transform_random_crop}()},
\code{\link{transform_random_erasing}()},
\code{\link{transform_random_grayscale}()},
\code{\link{transform_random_horizontal_flip}()},
\code{\link{transform_random_order}()},
\code{\link{transform_random_resized_crop}()},
\code{\link{transform_random_rotation}()},
\code{\link{transform_random_vertical_flip}()},
\code{\link{transform_resize}()},
\code{\link{transform_resized_crop}()},
\code{\link{transform_rgb_to_grayscale}()},
\code{\link{transform_rotate}()},
\code{\link{transform_ten_crop}()},
\code{\link{transform_to_tensor}()},
\code{\link{transform_vflip}()}
}
\concept{transforms}
