% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxboot.R
\name{toxboot}
\alias{toxboot}
\title{Main function to sample, fit, and write results to mongoDB}
\usage{
toxboot(dat, m4id, boot_method, replicates = 100, concvals = F,
  destination = "memory")
}
\arguments{
\item{dat}{A data.table. Required columns are: logc: numeric, contains
concentrations resp: numeric, normalized response values paired with
concentrations m3id: numeric, value unique to each row corresponding to an
individual concentration and response m4id: numeric, value unique to an
aeid/spid pair. Multiple m3ids per m4id aeid: numeric, assay id spid:
character, sample ID bmad: numeric, baseline mad. Unique to an aeid.}

\item{m4id}{numeric length 1, m4id to bootstrap. Choice of m4id will
determine which rows are selected, and therefore the values of logc, resp,
m3id, aeid, spid, and bmad.}

\item{boot_method}{parameter passed to \code{toxbootReplicates} to determine
sampling method}

\item{replicates}{number of bootstrap samples. Default 100}

\item{concvals}{logical, default is FALSE. If TRUE, dose response samples
written to the database as well.}

\item{destination}{string length 1, options are "mongo", "mysql", "file",
"memory"}
}
\description{
\code{toxboot} is the main function that performs the bootstrap sampling,
fitting, and writing to the database
}
\details{
\code{toxboot} is the workhorse function of this package. This
  function will typically be wrapped in a mclapply to perform in parallel
  using \code{\link{toxbootmc}}. The dose response data is passed to
  \code{toxbootReplicates}. The returned matrix is passed to
  \code{tcpl::tcplFit}.

  There are multiple options for saving the results, based on the value of
  \code{destination}.

  \itemize{

  \item mongo : If \code{destination} is set to "mongo" a connection to the
  mongo database will be created and the results will be written using the
  \code{rmongodb} package. The connection will be established using the
  parameters retrieved using \code{\link{toxbootConfList}} by the function
  \code{\link{toxbootConnectMongo}}. See the documentation on these functions
  as well as \code{\link{toxbootConf}} for how to properly setup the MongoDB
  environment. For large scale screening of uncertainty parameters it is
  recommended that MongoDB be used for performance and scaling.

  \item mysql :

  \item file : A directory \code{toxboot/} will be created. A csv file for
  each m4id will be created with name set to the value of m4id. The format of
  the file will be tabular with one row for each bootstrap replicate.
  Subsequent runs will be appended onto the file. This way further bootstrap
  results can be created without loss of previous computational work. Note
  that the file size can get quite large if many curves are run. With 1000
  replicates the file size will typically range from 300 to 600 KB per m4id.

  \item memory : Results will be returned as a single data.table. This is a
  reasonable option for checking a few curves or even an entire assay with
  1000 replicates if a suitable amount of memory is available. Care must be
  taken as the resulting data.table can become multiple GB in memory } The
  fitted results are assembled into a bson object using \code{rmongodb} and
  written to the mongoDB.
}
\seealso{
\code{\link{toxbootReplicates}}
}

