% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/PlotWrapper.R,
%   R/accessor-methods.R
\docType{methods}
\name{coordSystem}
\alias{coordSystem}
\alias{coordSystem,PlotFeatureSet-method}
\alias{coordSystem,ggplot-method}
\alias{coordSystem,trellis-method}
\alias{coordSystem,gTree-method}
\title{Accessor method for the coordinate system (slot "coordsys") of the plot object.}
\usage{
coordSystem(object)

\S4method{coordSystem}{PlotFeatureSet}(object)

\S4method{coordSystem}{ggplot}(object)

\S4method{coordSystem}{trellis}(object)

\S4method{coordSystem}{gTree}(object)

\S4method{coordSystem}{PlotFeatureSet}(object)
}
\arguments{
\item{object}{An object of class  PlotFeatureSet, GGplotFeatureSet, TrellisFeatureSet, ggplot, or trellis.}
}
\value{
A character vector describing the coordinate system employed in the plot.
}
\description{
Get the coordinate system for a plot or PlotFeatureSet.
}
\examples{
library(ggplot2)
mt = datasets::mtcars
plt = qplot(mt$mpg, mt$cyl)
fs = makeFeatureSet(plt)
coordSystem(fs)
}
