% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/accessor-methods.R
\docType{methods}
\name{tags<-}
\alias{tags<-}
\alias{editTags}
\alias{tags}
\alias{tags<-,FeatureSet-method}
\alias{tags<-,ggplot-method}
\alias{tags<-,trellis-method}
\alias{tags<-,gTree-method}
\alias{editTags,FeatureSet-method}
\alias{tags,FeatureSet-method}
\alias{tags,ggplot-method}
\alias{tags,trellis-method}
\alias{tags,gTree-method}
\alias{tags,ANY-method}
\title{Accessors for the tags of FeatureSet objects}
\usage{
tags(object) <- value

editTags(object, value, option)

tags(object)

\S4method{tags}{FeatureSet}(object) <- value

\S4method{tags}{ggplot}(object) <- value

\S4method{tags}{trellis}(object) <- value

\S4method{tags}{gTree}(object) <- value

\S4method{editTags}{FeatureSet}(object, value, option = c("replace", "add",
  "remove"))

\S4method{tags}{FeatureSet}(object)

\S4method{tags}{ggplot}(object)

\S4method{tags}{trellis}(object)

\S4method{tags}{gTree}(object)

\S4method{tags}{ANY}(object)
}
\arguments{
\item{object}{An object of (super)class FeatureSet}

\item{value}{A character vector of tags.}

\item{option}{One of c("replace", "add", "remove"), with default "replace" (equivalent to "tags<-" with an additional uniqueness check), describing the action to be taken with the tag vector provided.}

\item{...}{Additional named arguments.}
}
\value{
A modified object of (super)class PlotFeatureSet.

A modified object of (super)class PlotFeatureSet.
}
\description{
Get or set the tags associated with a FeatureSet object. This should not be called directly.
}
\examples{
library(ggplot2)
mt = datasets::mtcars
plt = qplot(mt$mpg, mt$cyl)
fs = makeFeatureSet(plt)
tags(fs)
}
