% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.neuralnet}
\alias{train.neuralnet}
\title{train.neuralnet}
\usage{
train.neuralnet(
  formula,
  data,
  hidden = 1,
  threshold = 0.01,
  stepmax = 1e+05,
  rep = 1,
  startweights = NULL,
  learningrate.limit = NULL,
  learningrate.factor = list(minus = 0.5, plus = 1.2),
  learningrate = NULL,
  lifesign = "none",
  lifesign.step = 1000,
  algorithm = "rprop+",
  err.fct = "sse",
  act.fct = "logistic",
  linear.output = TRUE,
  exclude = NULL,
  constant.weights = NULL,
  likelihood = FALSE
)
}
\arguments{
\item{formula}{a symbolic description of the model to be fitted.}

\item{data}{a data frame containing the variables specified in formula.}

\item{hidden}{a vector of integers specifying the number of hidden neurons (vertices) in each layer.}

\item{threshold}{a numeric value specifying the threshold for the partial derivatives of the error function as stopping criteria.}

\item{stepmax}{the maximum steps for the training of the neural network. Reaching this maximum leads to a stop of the neural network's training process.}

\item{rep}{the number of repetitions for the neural network's training.}

\item{startweights}{a vector containing starting values for the weights. Set to NULL for random initialization.}

\item{learningrate.limit}{a vector or a list containing the lowest and highest limit for the learning rate. Used only for RPROP and GRPROP.}

\item{learningrate.factor}{a vector or a list containing the multiplication factors for the upper and lower learning rate. Used only for RPROP and GRPROP.}

\item{learningrate}{a numeric value specifying the learning rate used by traditional backpropagation. Used only for traditional backpropagation.}

\item{lifesign}{a string specifying how much the function will print during the calculation of the neural network. 'none', 'minimal' or 'full'.}

\item{lifesign.step}{an integer specifying the stepsize to print the minimal threshold in full lifesign mode.}

\item{algorithm}{a string containing the algorithm type to calculate the neural network. The
following types are possible: 'backprop', 'rprop+', 'rprop-', 'sag', or 'slr'. 'backprop'
refers to backpropagation, 'rprop+' and 'rprop-' refer to the resilient backpropagation
with and without weight backtracking, while 'sag' and 'slr' induce the usage of the modified globally
convergent algorithm (grprop). See Details for more information.}

\item{err.fct}{a differentiable function that is used for the calculation of the error. Alternatively, the strings 'sse'
and 'ce' which stand for the sum of squared errors and the cross-entropy can be used.}

\item{act.fct}{a differentiable function that is used for smoothing the result of the cross product of the covariate or neurons and the weights.
Additionally the strings, 'logistic' and 'tanh' are possible for the logistic function and tangent hyperbolicus.}

\item{linear.output}{logical. If act.fct should not be applied to the output neurons set linear output to TRUE, otherwise to FALSE.}

\item{exclude}{a vector or a matrix specifying the weights, that are excluded from the calculation.
If given as a vector, the exact positions of the weights must be known. A matrix with n-rows and 3 columns will exclude n weights,
 where the first column stands for the layer, the second column for the input neuron and the third column for the output neuron of the weight.}

\item{constant.weights}{a vector specifying the values of the weights that are excluded from the training process and treated as fix.}

\item{likelihood}{logical. If the error function is equal to the negative log-likelihood function, the
information criteria AIC and BIC will be calculated. Furthermore the usage of confidence.interval is meaningfull.}
}
\value{
A object neuralnet.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[neuralnet]{neuralnet}}.
}
\note{
the parameter information was taken from the original function \code{\link[neuralnet]{neuralnet}}.
}
\seealso{
The internal function is from package \code{\link[neuralnet]{neuralnet}}.
}
