% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pltmle.R
\name{pltmle}
\alias{pltmle}
\title{Counterfactual means for a Pooled LTMLE}
\usage{
pltmle(
  formula,
  outcome,
  treatment,
  covariates,
  baseline,
  ntimes_interval,
  number_traj,
  time,
  time_values,
  identifier,
  obsdata,
  traj,
  total_followup,
  treshold = treshold
)
}
\arguments{
\item{formula}{Specification of the model for the outcome to be fitted.}

\item{outcome}{Name of the outcome variable.}

\item{treatment}{Time-varying treatment.}

\item{covariates}{Covariates.}

\item{baseline}{Name of baseline covariates.}

\item{ntimes_interval}{Length of a time-interval (s).}

\item{number_traj}{An integer to choose the number of trajectory groups.}

\item{time}{Name of the time variable.}

\item{time_values}{Measuring times.}

\item{identifier}{Name of the column of the unique identifier.}

\item{obsdata}{Observed data in wide format.}

\item{traj}{Matrix of indicators for the trajectory groups.}

\item{total_followup}{Number of measuring times per interval.}

\item{treshold}{For weight truncation.}
}
\value{
\item{list_pltmle_countermeans}{ Counterfactual means and influence functions with the pooled ltmle.}
\item{D}{Influence functions}
}
\description{
Function to estimate counterfactual means for a pooled LTMLE.
}
\examples{
\donttest{
obsdata_long = gendata(n = 2000, format = "long",total_followup = 3, seed = 945)
baseline_var <- c("age","sex")
covariates <- list(c("hyper2011", "bmi2011"),
c("hyper2012", "bmi2012"),c("hyper2013", "bmi2013"))
treatment_var <- c("statins2011","statins2012","statins2013")
time_values <- c(2011,2012,2013)
formulaA = as.formula(cbind(statins, 1 - statins) ~ time)
restraj = build_traj(obsdata = obsdata_long, number_traj = 3,
formula = formulaA, identifier = "id")
datapost = restraj$data_post
trajmsm_long <- merge(obsdata_long, datapost, by = "id")
    AggFormula <- as.formula(paste("statins", "~", "time", "+", "class"))
    AggTrajData <- aggregate(AggFormula, data = trajmsm_long, FUN = mean)
    AggTrajData
trajmsm_long[ , "traj_group"] <- trajmsm_long[ , "class"]
obsdata= reshape(trajmsm_long, direction = "wide", idvar = "id",
v.names = c("statins","bmi","hyper"), timevar = "time", sep ="")
formula =  as.formula(" y ~ statins2011 + statins2012 + statins2013 +
hyper2011 + bmi2011 + hyper2012 + bmi2012 +
 hyper2013 + bmi2013 + age + sex ")
class = factor(predict_traj(identifier = "id", total_followup = 3,
        treatment = "statins", time = "time", time_values = time_values,
        trajmodel = restraj$traj_model)$post_class);
traj=t(sapply(1:8,function(x)sapply(1:3,function(i)ifelse(class[x]==i,1,0))))
traj[,1]=1
res_pltmle = pltmle(formula = formula, outcome = "y",treatment = treatment_var,
covariates = covariates, baseline = baseline_var, ntimes_interval = 3, number_traj = 3,
 time =  "time",time_values = time_values,identifier = "id",obsdata = obsdata,
traj=traj, treshold = 0.99)
res_pltmle$counter_means
}
}
\author{
Awa Diop, Denis Talbot
}
