% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.tramME}
\alias{residuals.tramME}
\title{Residuals of a tramME model}
\usage{
\method{residuals}{tramME}(
  object,
  param = NULL,
  newdata = NULL,
  fix_smooth = !is.null(newdata),
  ...
)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{param}{An optional named list of parameter values (beta and theta).
See details.  Optionally, gamma elements can also be added, which leads to
'fixing' those random effects terms at the supplied values.}

\item{newdata}{An optional \code{data.frame} of observations for which we
want to calculate the residuals.}

\item{fix_smooth}{Logical; it is set to \code{TRUE} by default, if
\code{newdata} is supplied.  The random effects parameters corresponding
the smooth terms are fixed and not fitted (posterior mode) to
\code{newdata} instead they are treated just like fixed effects
parameters. See details.}

\item{...}{Optional arguments (for consistency with generic)}
}
\description{
Calculates the score residuals of an intercept term fixed at 0.
}
\examples{

library("survival")
fit <- SurvregME(Surv(time, status) ~ rx + (1 | litter), data = rats)
resid(fit)

}
