% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velocity.R
\name{velocity}
\alias{velocity}
\alias{velocity.default}
\alias{velocity.units}
\alias{velocity.stars}
\alias{velocity.transfR}
\title{Streamflow velocity estimation}
\usage{
velocity(hl, ...)

\method{velocity}{default}(hl, lagtime, method = "loire2016", ...)

\method{velocity}{units}(hl, lagtime = NULL, method = "loire2016", ...)

\method{velocity}{stars}(hl, ...)

\method{velocity}{transfR}(hl, ...)
}
\arguments{
\item{hl}{hydraulic length of class \code{stars}, \code{matrix}, \code{vector} or \code{transfR}.
If no unit is provided, \code{hl} is assumed to be in [m].}

\item{...}{further arguments passed to or from other methods}

\item{lagtime}{lag time of the catchment. If no unit is provided, \code{lagtime} is assumed to be in [h].}

\item{method}{character string describing the method to estimate the velocity. One of "loire2016" (default), "brittany2013"
or "lagtime" (see details).}
}
\value{
A numeric value of class units, or if \code{hl} is a transfR object,
the same transfR object incremented by the "uc" attribute.
}
\description{
Estimate streamflow velocity in average over the catchment.
}
\details{
Estimate the average streamflow velocity of the catchment from three different
approaches. Method "lagtime" estimates the velocity from the ratio between the mean
hydraulic length and the lag time of the catchment. Method "loire2016" estimates the
velocity from a regression based on hydraulic length only:
\deqn{a \cdot hl^b}
where \eqn{a=4.38e-4} and \eqn{b=0.69} have been calibrated over the Loire river basin \insertCite{deLavenne2016}{transfR}.
Method "brittany2013" used a similar regression calibrated for the French Brittany region where \eqn{a=8.59e-4}
and \eqn{b=0.61} \insertCite{deLavenne2013}{transfR}.
}
\examples{
data(Oudon)
velocity(Oudon$hl[[1]], method="loire2016")

object <- as_transfr(st=Oudon$obs, hl=Oudon$hl)
object <- velocity(object)
object$uc
}
\references{
\insertRef{deLavenne2013}{transfR}

\insertRef{deLavenne2016}{transfR}
}
