% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_transfr.R
\name{quick_transfr}
\alias{quick_transfr}
\title{Transfer of observed discharge from gauged catchments to ungauged catchments}
\usage{
quick_transfr(
  obs,
  sim,
  velocity = "loire2016",
  distance = "rghosh",
  gres = 5,
  weightO = 0.8,
  weightC = 0.2,
  power = 1,
  ndonors = 5,
  maxdist = 50000,
  flexible_donor = TRUE,
  cv = FALSE,
  save_donor = FALSE,
  warmup = 10,
  cooldown = 8,
  dosplit = TRUE,
  split = 30,
  parallel = FALSE,
  cores = NULL,
  verbose = TRUE
)
}
\arguments{
\item{obs}{"transfR" object of the gauged catchments}

\item{sim}{"transfR" object of the ungauged catchments}

\item{velocity}{character string describing the method to estimate the streamflow velocity.
See \link{velocity} for the available options (\code{method} argument)}

\item{distance}{character string describing the method to compute the distance between catchments.
See \link{hdist} for the available options (\code{method} argument)}

\item{gres}{resolution of spatial discretisation (number of points by km²) for Ghosh
distance. See \link{hdist} for more details}

\item{weightO}{weight given to the distance between outlets if distance method is "combined".
See \link{hdist} for more details}

\item{weightC}{weight given to the distance between centroids if distance method is "combined".
See \link{hdist} for more details}

\item{power}{exponent applied in the inverse distance weighting strategy. See \link{weightr} for more details}

\item{ndonors}{maximum number of catchments to be used to simulate discharge of an ungauged
catchment. See \link{weightr} for more details}

\item{maxdist}{maximum distance between a gauged and an ungauged catchment to allow the net rainfall
to be transfered. This threshold is applied on the \code{mdist} distance matrix. If no units is provided,
\code{maxdist} is assumed to be in [m]. See \link{mixr} for more details}

\item{flexible_donor}{boolean indicating if the donor catchments can change during the simulation period
according to the availability of discharge observations. See \link{weightr} for more details}

\item{cv}{boolean indicating if cross validation evaluation should be done. If true, it will estimate
the net rainfall of every gauged catchments (\code{obs}) as if they were ungauged (leave-one-out evaluation)}

\item{save_donor}{boolean indicating if the net rainfall of each of the \code{ndonors} catchments
should be stored in the sim object for further analysis. If true, it is adding three new space-time attributes
in the \code{sim} object called "RnDonor", "Idonor" and "Wdonor" describing the net rainfall, the id and
the weight of the donor catchments respectively. See \link{mixr} for more details}

\item{warmup}{length of the warmup period. If no unit is provided, \code{warmup} is assumed to be in [days].
See \link{inversion} for more details}

\item{cooldown}{length of the period removed at the end of the simulation. If no unit is provided,
\code{cooldown} is assumed to be in [days]. See \link{inversion} for more details}

\item{dosplit}{boolean, if true the inversion is performed by
subperiods of length defined by \code{split}. See \link{inversion} for more details}

\item{split}{length the subperiods if dosplit is true. If no unit is provided, \code{split} is assumed to be
in [days]. See \link{inversion} for more details}

\item{parallel}{logical indicating if the computation should be parallelised}

\item{cores}{the number of cores to use for parallel execution if \code{parallel} is TRUE.
If not specified, the number of cores is set to the value of \code{parallel::detectCores()}}

\item{verbose}{boolean indicating if information messages should be written to the console}
}
\value{
The \code{sim} object incremented by the new computed attributes
}
\description{
Wrap up all the modelling steps into one function for a quick implementation of this R package.
}
\details{
The function applies sequentially the following functions: \link{velocity}, \link{uh},
\link{lagtime}, \link{rapriori}, \link{inversion}, \link{hdist}, \link{mixr} and \link{convolution}.
Please refer to the help of each of these functions and to \link{transfR} for a general description of the
modelling approach.
}
\examples{
\donttest{data(Oudon)
obs <- as_transfr(st = Oudon$obs[,,1:3], hl = Oudon$hl[1:3]) #gauged catchments
sim <- as_transfr(st = Oudon$obs[,,4:6], hl = Oudon$hl[4:6]) #catchments considered as ungauged
sim <- quick_transfr(obs, sim)}
}
\seealso{
\link{velocity}, \link{uh}, \link{lagtime}, \link{rapriori}, \link{inversion},
\link{hdist}, \link{mixr}, \link{convolution}
}
