% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeDates.R
\name{computeXdate_hour}
\alias{computeXdate_hour}
\title{Extracts the hour value out of a given date}
\usage{
computeXdate_hour(x=NULL)
}
\arguments{
\item{x}{atomic object of class \code{character, POSIXlt  or  POSIXt} holding date data.}
}
\value{
Returns a character string with the hour value values.
}
\description{
R Implementation of the SPSS \code{XDATE.HOUR} Function. \code{computeXdate_hour} is a helper function for xpssCompute.
}
\details{
computeXdate_hour extract the hour component out of the date string, the other date and time componentes will be omitted.
}
\examples{
xpssCompute(x="2015-02-15 20:22:20", fun="computeXdate_hour")
xpssCompute(x="2022-02-20 21:22:12", fun="computeXdate_hour")
}
\author{
Bastian Wiessner
}
\seealso{
\code{\link{computeXdate_date}} \code{\link{computeDate_wkyr}}
}
\keyword{internal}

