% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-format-vector.R
\name{format_vector}
\alias{format_vector}
\title{Format Vectors}
\usage{
format_vector(
  x = vector(),
  label = NULL,
  level = 0L,
  indent = 1L,
  fill_names = FALSE,
  null = constant("null"),
  empty = constant("empty"),
  validate = TRUE
)
}
\arguments{
\item{x}{A \link[=vector]{vector} of any \link[=vector]{atomic} mode, a
\link[=list]{list}, or a \link[=pairlist]{pairlist}. It can be empty
and it can contain \link[base:NA]{NA} values.}

\item{label}{A \code{NULL}, or a non-empty and non-\link[base:NA]{NA} character
string. A (top) descriptive label for \code{x}. It is used to preserve,
and output all names in recursive calls. The value passed to \code{label}
is considered to be at \code{level} 0, and is not indented.}

\item{level}{A non-\link[base:NA]{NA} integer value. The current depth, or
current \emph{nesting level} to use for indentation purposes.}

\item{indent}{A non-\link[base:NA]{NA} integer value. The number of single
space(s) to use for each \code{level} when indenting name/value pairs.}

\item{fill_names}{A non-\link[base:NA]{NA} logical value. Should \code{NULL} and
empty names be replaced by names created from the elements' underlying
positions? Positions are relative to each \code{level}.}

\item{null}{A non-empty and non-\link[base:NA]{NA} character string. The value
to use to represent \code{NULL} and empty parlists (they are conceptually the
same thing).}

\item{empty}{A non-empty and non-\link[base:NA]{NA} character string. The
value to use to represent empty vectors, excluding \code{NULL}. See \code{null}
above for the latter. The \link[=typeof]{type} of the underlying empty
object is added to \code{empty} for convenience. See Examples below.}

\item{validate}{A non-\link[base:NA]{NA} logical value. Should the arguments be
validated before being used? This argument should be left as is.}
}
\value{
A character vector, possibly trimmed by \code{\link[=str_trim]{str_trim()}}.
}
\description{
Format \link[=vector]{atomic} vectors, \link[=list]{lists}, and
\link[=pairlist]{pairlists}.
}
\details{
\code{\link[=format_vector]{format_vector()}} is an alternative to \code{\link[utils:str]{utils::str()}} that exposes a much
simpler generic formatting interface and yields terser outputs of name/value
pairs. Indentation is used for nested values.

\code{\link[=format_vector]{format_vector()}} does not attempt to cover all \R objects like
\code{\link[utils:str]{utils::str()}}. Instead, it (merely) focuses on efficiently handling the
types used by \code{\link{transltr}}. It is the low-level \emph{workhorse} function of
\code{\link[=format.Translator]{format.Translator()}}, \code{\link[=format.Text]{format.Text()}}, and \code{\link[=format.Location]{format.Location()}}.
}
\seealso{
\code{\link[=str_trim]{str_trim()}}

Other utility functions: 
\code{\link{stops}()},
\code{\link{str_to}()},
\code{\link{vapply_1l}()}
}
\concept{utility functions}
\keyword{internal}
