% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hla_mismatch.R
\name{hla_mm_level}
\alias{hla_mm_level}
\title{HLA mismatch level}
\usage{
hla_mm_level(a, b, dr)
}
\arguments{
\item{a}{numeric vector of HLA A locus mismatches (0-2)}

\item{b}{numeric vector of HLA B locus mismatches (0-2)}

\item{dr}{numeric vector of HLA DR locus mismatches (0-2)}
}
\value{
numeric vector of HLA mismatch levels (1-4)
}
\description{
Vectorised function to calculate HLA mismatch level as used in UK national deceased
donor kidney matching scheme.
}
\details{
Mismatches should be provided as numeric vectors of integers with values from 0 to 2
The HLA mismatch level is derived from UK kidney matching policies which can be found on the
NHS Blood & Transplant ODT website at www.odt.nhs.uk
}
\examples{
hla_mm_level(a = 0, b = 1, dr = 1)
}
