% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crude.bd.est.R
\name{crude.bd.est}
\alias{crude.bd.est}
\title{Crudely estimates extinction and speciation}
\usage{
crude.bd.est(tree)
}
\arguments{
\item{tree}{a \code{"phylo"} object.}
}
\value{
A \code{"bd.params"} object to be fed to \code{\link{treats}}.
}
\description{
Very crudely estimates the extinction and speciaton rate of a tree.
}
\details{
This function calculates the extinction rate as the number of extinction events in the tree divided by the tree age (expressed in tree age units - e.g. million years). The speciation rate is calculated as the number of speciation events divided by the tree age. If the input tree has no \code{$root.time} element, the speciation and extinction rate are just the number of speciation and extinction events.
\emph{NOTE} that this function is a very crude way to estimate rates of extinction and speciation: the rates are calculated from the raw data (not estimated), ignore sampling biases of the data and the variability in rates. For correct model base approaches see for example \code{\link[ape]{birthdeath}} or \code{\link[ape]{bd.ext}}.
}
\examples{
set.seed(1)
## Generating a random tree
my_tree <- rtree(20)
## Calculating the number of speciations and extinctions events
crude.bd.est(my_tree)

## Adding a root time
my_tree$root.time <- 5
## Calculating the number of speciations and extinctions
## per units of time
crude.bd.est(my_tree)

}
\seealso{
\code{\link{treats}} \code{\link{make.bd.params}}
}
\author{
Thomas Guillerme
}
