% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_data.R
\name{validate_data}
\alias{validate_data}
\title{Validate Data and Optionally Delete Missing Data}
\usage{
validate_data(x, type = c(NA, "angle_counts", "boundaries"), clean = FALSE)
}
\arguments{
\item{x}{A tree or angle count data set.}

\item{type}{The type of data, stick with the default to let us guess.}

\item{clean}{Omit missing data? If the input contains missing data in the
columns needed by \code{\link{get_correction_factors}}, the affected
observations
may be deleted. Otherwise an error is thrown.}
}
\value{
A tree data set. The input, if that was valid data, the cleaned
input otherwise. Throws an error if columns are missing.
}
\description{
The 2012 data of the federal database contains tract 18063, corner 2.
There are boundaries recorded for that corner, nevertheless tree 14 has no
azimuth measurement. This function therefore checks for the data sets not
having missing
data in the columns needed by \code{\link{get_correction_factors}} and
optionally removes affected observations.
It does not cross check whether missing data is really needed (azimuth is
not when there is no boundary recorded for that tracts corner).
}
\examples{
boundaries <- get(data("boundaries", package = "treePlotArea"))
nrow(boundaries)
nrow(validate_data(x = boundaries))
boundaries[1, "enr"] <- NA
try(validate_data(boundaries))
nrow(validate_data(boundaries, clean = TRUE))
}
