% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_node_heights.R
\name{estimate_node_heights}
\alias{estimate_node_heights}
\title{Calculate expected time to branching point of a species tree}
\usage{
estimate_node_heights(lambda, mu, n, k = 1)
}
\arguments{
\item{lambda}{speciation rate}

\item{mu}{extinction rate}

\item{n}{number of tips on tree}

\item{k}{branching point (k = 1 is the root and is the default)}
}
\value{
The expected branching time
}
\description{
Calculates the expected time to branching point of a
   species tree for a birth-death simulation given a speciation
   and extinction rate and a number of leaves, and a branching point.
}
\details{
By default this branching point is 1 which corresponds
to the root, k = 2 corresponds to the first branching point after
the root, k = 3 the second, and so on. For more details see Gernhard 2008.
}
\examples{
spec_rate <- 1.0
ext_rate <- 0.5
nt <- 10
estimate_node_heights(lambda = spec_rate, mu = ext_rate, n = nt)

estimate_node_heights(lambda = spec_rate, mu = ext_rate, n = nt, k = 2)
}
\references{
Gernhard, T. (2008). The conditioned reconstructed process. Journal of
    theoretical biology, 253(4), 769-778.
}
