% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/deprecated_sim_functions.R
\name{sim_cophyBD_ana}
\alias{sim_cophyBD_ana}
\alias{sim_cophylo_bdp_ana}
\title{Simulates a host-symbiont system using a cophylogenetic birth-death process}
\usage{
sim_cophyBD_ana(
  hbr,
  hdr,
  sbr,
  sdr,
  s_disp_r,
  s_extp_r,
  host_exp_rate,
  cosp_rate,
  time_to_sim,
  numbsim,
  host_limit = 0L,
  hs_mode = FALSE
)

sim_cophylo_bdp_ana(
  hbr,
  hdr,
  sbr,
  sdr,
  s_disp_r,
  s_extp_r,
  host_exp_rate,
  cosp_rate,
  time_to_sim,
  numbsim,
  host_limit = 0
)
}
\arguments{
\item{hbr}{host tree birth rate}

\item{hdr}{host tree death rate}

\item{sbr}{symbiont tree birth rate}

\item{sdr}{symbiont tree death rate}

\item{s_disp_r}{symbiont dispersal rate to new hosts}

\item{s_extp_r}{symbiont exirpation rate on h}

\item{host_exp_rate}{host shift speciation rate}

\item{cosp_rate}{cospeciation rate}

\item{time_to_sim}{time units to simulate until}

\item{numbsim}{number of replicates}

\item{host_limit}{Maximum number of hosts for symbionts (0 implies no limit)}

\item{hs_mode}{Boolean turning host expansion into host switching (explained above) (default = FALSE)}
}
\value{
A list containing the `host_tree`, the `symbiont_tree`, the
    association matrix in the present, with hosts as rows and smybionts as columns, and the history of events that have
    occurred.
}
\description{
Simulates a host-symbiont system using a cophylogenetic birth-death process
}
\details{
Simulates a cophylogenetic system using birth-death processes with
    anagenetic processes allowing symbiont to gain or loss associations with
    hosts. The host tree is simulated following a constant rate birth-death process
    with an additional parameter - the cospeciation rate. This rate works as
    the speciation rate with the additional effect that if cospeciation
    occurs the symbiont tree also speciates. The symbiont tree is related to
    the host tree via an association matrix that describes which lineages
    are associated with which. The symbiont tree has an independent
    birth-death process with the addition of a host shift speciation rate
    that allows for the addition of more associated hosts upon symbiont
    speciation. The anagenetic processes are modeled using a poisson process
    occurring along the tree. The dispersal to hosts is at present random;
    there is no preferential host expansion.

    Host expansions are similar to the more commonly found host switching. 
    In this model, host-expansion speciation describes events where a symbiont 
    speciates and at that time, both descendants retain the ancestral host 
    associations. Randomly one of these descendant symbionts then randomly acquires a new 
    host. When the option `host_switch_mode = TRUE`, the behavior of this changes to a 
    more traditional host switching where one descendant retains the ancestral range and
    the other gains a novel host association.
}
\examples{

host_mu <- 0.5 # death rate
host_lambda <- 2.0 # birth rate
numb_replicates <- 10
time <- 1.0
symb_mu <- 0.2
symb_lambda <- 0.4
host_shift_rate <- 0.0
cosp_rate <- 2.0

cophylo_pair <- sim_cophyBD_ana(hbr = host_lambda,
                           hdr = host_mu,
                           cosp_rate = cosp_rate,
                           s_disp_r = 1,
                           s_extp_r = 0.4,
                           host_exp_rate = host_shift_rate,
                           sdr = symb_mu,
                           sbr = symb_lambda,
                           numbsim = numb_replicates,
                           time_to_sim = time)

}
