% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_fields.R
\name{add_field}
\alias{add_field}
\alias{add_field_checkbox}
\alias{add_field_date}
\alias{add_field_dropdown}
\alias{add_field_number}
\alias{add_field_text}
\title{Add a custom field}
\usage{
add_field(id, type, name = "New field", body = NULL, ...)

add_field_checkbox(id, name = "New checkbox", body = NULL, ...)

add_field_date(id, name = "New date", body = NULL, ...)

add_field_dropdown(id, name = "New dropdown", body = NULL, ...)

add_field_number(id, name = "New number", body = NULL, ...)

add_field_text(id, name = "New text", body = NULL, ...)
}
\arguments{
\item{id}{Board ID}

\item{type}{Custom field type}

\item{name}{Custom field name}

\item{body}{Named list with additional parameters}

\item{...}{Additional arguments passed to \code{\link[=create_resource]{create_resource()}}}
}
\description{
Create a new custom field definition and attach it to the board.
}
\details{
For \code{add_field_dropdown} - options can be provided using a single (optionally
named) vector:
\code{body = list(options = c(red = "Alert", green = "Ok", "Nothing"))}
}
\seealso{
Other functions to handle custom fields: 
\code{\link{add_field_option}()},
\code{\link{delete_field_option}()},
\code{\link{delete_field}()},
\code{\link{update_card_field}()},
\code{\link{update_field}()}
}
\concept{functions to handle custom fields}
