% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{run_equiv}
\alias{run_equiv}
\title{Fit CLMM and Run Equivalence Test}
\usage{
run_equiv(.data, main_effect = FALSE, delta = 0.14)
}
\arguments{
\item{.data}{Data frame, with the format as resulting from a call
to \code{\link{gen_data}}.}

\item{main_effect}{Whether to test the main effect of repetition
(TRUE) or the repetition-by-interval interaction (FALSE; the
default).}

\item{delta}{Smallest (raw) effect size of interest (log odds scale).}
}
\value{
A vector with p-values; the element(s) named \code{simple}
  provide p-values for simple effects; the element(s) named
  \code{equiv} provides the p-value for the corresponding
  equivalence test.
}
\description{
Fit CLMM and Run Equivalence Test
}
\details{
This function is intended to be used in data simulation.
}
\examples{

set.seed(62)
dat <- gen_data(24)
\donttest{run_equiv(dat, main_effect = TRUE)}

}
