% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_bind.R, R/ts_chain.R
\name{ts_bind}
\alias{ts_bind}
\alias{ts_chain}
\title{Bind Time Series}
\usage{
ts_bind(...)

ts_chain(...)
}
\arguments{
\item{...}{ts-boxable time series, objects of class \code{ts}, \code{xts}, \code{data.frame}, \code{data.table}, or \code{tibble}. Or a numeric vector (see examples).}
}
\value{
A ts-boxable object of the same class as the input.
If series of different classes are combined, the class of the first series is
used (if possible).
}
\description{
Combine time series to a new, single time series. \code{ts_bind} combines time
series as they are, \code{ts_chain} chains them together, using percentage change
rates.
}
\examples{
ts_bind(ts_span(mdeaths, end = "1975-12-01"), fdeaths)
ts_bind(mdeaths, c(2, 2))
ts_bind(mdeaths, 3, ts_bind(fdeaths, c(99, 2)))
ts_bind(ts_dt(mdeaths), AirPassengers)

# numeric vectors
ts_bind(12, AirPassengers, c(2, 3))

ts_chain(ts_span(mdeaths, end = "1975-12-01"), fdeaths)
\donttest{
ts_plot(ts_pc(ts_c(
  comb = ts_chain(ts_span(mdeaths, end = "1975-12-01"), fdeaths),
  fdeaths
)))
}
}
\seealso{
\link{ts_c} to collect multiple time series
}
