% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.tsgarch.estimate}
\alias{vcov.tsgarch.estimate}
\alias{vcov}
\title{The Covariance Matrix of the Estimated Parameters}
\usage{
\method{vcov}{tsgarch.estimate}(object, adjust = FALSE, type = c("H", "OP", "QMLE", "NW"), ...)
}
\arguments{
\item{object}{an object of class tsgarch.estimate.}

\item{adjust}{logical. Should a finite sample adjustment be made? This amounts
to multiplication with n/(n-k) where n is the number of observations and k
the number of estimated parameters.}

\item{type}{valid choices are \dQuote{H} for using the analytic hessian
for the bread, \dQuote{OP} for the outer product of gradients, \dQuote{QMLE}
for the Quasi-ML sandwich estimator (Huber-White), and \dQuote{NW} for the Newey-West
adjusted sandwich estimator (a HAC estimator).}

\item{...}{additional parameters passed to the Newey-West bandwidth function to
determine the optimal lags.}
}
\value{
The variance-covariance matrix of the estimated parameters.
}
\description{
The Covariance Matrix of the Estimated Parameters
}
