% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_sfac.R
\name{sim_sfac}
\alias{sim_sfac}
\title{Simulate a seasonal factor}
\usage{
sim_sfac(
  n,
  freq = 12,
  sd = 1,
  change_sd = 0.02,
  beta_1 = 0.9,
  beta_tau = 0,
  start = c(2020, 1),
  multiplicative = TRUE,
  ar = NULL,
  ma = NULL,
  model = c(1, 1, 1),
  sc_model = list(order = c(1, 1, 1), ar = 0.65, ma = 0.25),
  smooth = TRUE,
  burnin = 3,
  extra_smooth = FALSE
)
}
\arguments{
\item{n}{Number of observations}

\item{freq}{Frequency of the time series}

\item{sd}{Standard deviation of the seasonal factor}

\item{change_sd}{Standard deviation of simulation change to seasonal factor}

\item{beta_1}{Persistance wrt to previous period of the seasonal change}

\item{beta_tau}{Persistance wrt to one year/cycle before of the seasonal change}

\item{start}{Start date of output time series}

\item{multiplicative}{Boolean. Should multiplicative seasonal factors be simulated}

\item{ar}{AR parameter}

\item{ma}{MA parameter}

\item{model}{Model for initial seasonal factor}

\item{sc_model}{Model for the seasonal change}

\item{smooth}{Boolean. Should initial seasonal factor be smoothed}

\item{burnin}{(burnin*n-n) is the burn-in period}

\item{extra_smooth}{Boolean. Should the seasonal factor be smooth on a period-by-period basis}
}
\value{
The function returns a time series of class \code{ts} containing a seasonal or periodic effect.
}
\description{
Simulate a seasonal factor
}
\details{
Standard deviation of the seasonal factor is in percent if a multiplicative time series model is assumed. Otherwise it is in unitless.
Using a non-seasonal ARIMA model does not impact the seasonality of the time series. It can just make it easier for human eyes to grasp the seasonal nature of the series. The definition of the ar and ma parameter needs to be inline with the chosen model.
}
\examples{
ts.plot(sim_sfac(60))
}
\references{
Ollech, D. (2021). Seasonal adjustment of daily time series. Journal of Time Series Econometrics. \doi{10.1515/jtse-2020-0028}
}
\author{
Daniel Ollech
}
