% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_simpsons.R
\name{theme_simpsons}
\alias{theme_simpsons}
\title{theme_simpsons}
\usage{
theme_simpsons(text.font = NULL, title.font = NULL,
  legend.font = NULL, title.size = 18, text.size = 14,
  subtitle.size = 12, axis.title.size = 14, axis.text.size = 10,
  legend.title.size = 10, legend.text.size = 9,
  title.color = "#FFD235", subtitle.color = "#fee8c8",
  text.color = "#fee8c8", axis.title.color = "#fee8c8",
  axis.text.color = "#fee8c8", legend.title.color = "#ffffff",
  legend.text.color = "#ffffff", legend.position = "bottom",
  ticks = FALSE)
}
\arguments{
\item{text.font}{text font, Default: NULL}

\item{title.font}{title font, Default: NULL}

\item{legend.font}{legend font, Default: NULL}

\item{title.size}{title font size, Default: 18}

\item{text.size}{text font size, Default: 14}

\item{subtitle.size}{subtitle font size, Default: 12}

\item{axis.title.size}{axis title font size, Default: 14}

\item{axis.text.size}{axis text font size, Default: 10}

\item{legend.title.size}{legend title font size, Default: 10}

\item{legend.text.size}{legend text font size, Default: 9}

\item{title.color}{title color, Default: "#FFD235"}

\item{subtitle.color}{subtitle.color, Default: "#fee8c8"}

\item{text.color}{text color, Default: "#fee8c8"}

\item{axis.title.color}{axis title color, Default: "#fee8c8"}

\item{axis.text.color}{axis text color, Default: "#fee8c8"}

\item{legend.title.color}{legend title color, Default: "#ffffff"}

\item{legend.text.color}{legend text color, Default: "#ffffff"}

\item{legend.position}{legend position, Default: "bottom"}

\item{ticks}{add axis ticks, Default: FALSE}
}
\description{
The Simpsons theme, Recommended font: "Akbar"
}
\details{
In part inspired by `@nathancunn`'s blog posts on The Simpsons!
}
\examples{
library(ggplot2)

ggplot(airquality, aes(x = Day, y = Temp,
     group = as.factor(Month), color = as.factor(Month))) +
     geom_point(size = 2.5) +
     scale_color_simpsons() +
     theme_simpsons()
}
\seealso{
[ggplot2::theme]
}
