% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onestep_txshift.R
\name{onestep_txshift}
\alias{onestep_txshift}
\title{Compute One-Step Estimate of Counterfactual Mean Under Stochastic Shift
Intervention}
\usage{
onestep_txshift(
  data_internal,
  C = rep(1, nrow(data_internal)),
  V = NULL,
  delta,
  ipcw_estim,
  Qn_estim,
  Hn_estim,
  eif_reg_type = c("hal", "glm"),
  ipcw_fit_args,
  ipcw_efficiency = TRUE
)
}
\arguments{
\item{data_internal}{A \code{data.table} constructed internally by a call to
\code{\link{txshift}}. This contains the data elements needed for computing
the one-step estimator.}

\item{C}{A \code{numeric} indicator for whether a given observation censored
in the two-phase sampling procedure, used to compute an IPC-weighted
one-step estimator in cases where two-stage sampling is performed. Default
assumes no censoring.}

\item{V}{The covariates that are used in determining the sampling procedure
that gives rise to censoring. The default is \code{NULL} and corresponds to
scenarios in which there is no censoring (in which case all values in the
preceding argument \code{C} must be uniquely 1. To specify this, pass in a
NAMED \code{list} identifying variables amongst W, A, Y that are thought to
have played a role in defining the sampling/censoring mechanism (C).}

\item{delta}{A \code{numeric} value indicating the shift in the treatment to
be used in defining the target parameter. This is defined with respect to
the scale of the treatment (A).}

\item{ipcw_estim}{An object providing the value of the censoring mechanism
evaluated across the full data. This object is passed in after being
constructed by a call to the internal function \code{est_ipcw}.}

\item{Qn_estim}{An object providing the value of the outcome evaluated after
imposing a shift in the treatment. This object is passed in after being
constructed by a call to the internal function \code{est_Q}.}

\item{Hn_estim}{An object providing values of the auxiliary ("clever")
covariate, constructed from the treatment mechanism and required for
targeted minimum loss estimation. This object object should be passed in
after being constructed by a call to the internal function \code{est_Hn}.}

\item{eif_reg_type}{Whether a flexible nonparametric function ought to be
used in the dimension-reduced nuisance regression of the targeting step for
the censored data case. By default, the method used is a nonparametric
regression based on the Highly Adaptive Lasso (from \pkg{hal9001}). Set
this to \code{"glm"} to instead use a simple linear regression model.
In this step, the efficient influence function (EIF) is regressed against
covariates contributing to the censoring mechanism (i.e., EIF ~ V | C = 1).}

\item{ipcw_fit_args}{A \code{list} of arguments, all but one of which are
passed to \code{\link{est_ipcw}}. For details, consult the documentation
for \code{\link{est_ipcw}}. The first element (i.e., \code{fit_type}) is
used to determine how this regression is fit: "glm" for generalized linear
model, "sl" for a Super Learner, and "external" for a user-specified input
of the form produced by \code{\link{est_ipcw}}.}

\item{ipcw_efficiency}{Whether to invoke an augmentation of the IPCW-TMLE
procedure that performs an iterative process to ensure efficiency of the
resulting estimate. The default is \code{TRUE}; set to \code{FALSE} to use
an IPC-weighted loss rather than the IPC-augmented influence function.}
}
\value{
S3 object of class \code{txshift} containing the results of the
 procedure to compute a one-step estimate of the treatment shift parameter.
}
\description{
Compute One-Step Estimate of Counterfactual Mean Under Stochastic Shift
Intervention
}
\details{
Invokes the procedure to construct a one-step estimate of the
 counterfactual mean under a modified treatment policy.
}
