% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaldAndLR.R, R/printMethods.R
\name{LR_test}
\alias{LR_test}
\alias{print.lr}
\title{Perform likelihood ratio test}
\usage{
LR_test(gsmar1, gsmar2)

\method{print}{lr}(x, ..., digits = 4)
}
\arguments{
\item{gsmar1}{an object of class \code{'gsmar'} generated by \code{fitGSMAR} or \code{GSMAR}, containing
the \strong{freely estimated} model.}

\item{gsmar2}{an object of class \code{'gsmar'} generated by \code{fitGSMAR} or \code{GSMAR}, containing
the \strong{constrained} model.}

\item{x}{object of class \code{'lr'} generated by the function \code{LR_test}.}

\item{...}{currently not in use.}

\item{digits}{how many significant digits to print?}
}
\value{
Returns an object of class \eqn{'lr'} containing the test statistic and the related p-value.
}
\description{
\code{LR_test} performs a likelihood ratio test for a GMAR, StMAR, or G-StMAR model.
}
\details{
Performs a likelihood ratio test, testing the null hypothesis that the true parameter value lies
  in the constrained parameter space. Under the null, the test statistic is asymptotically
  \eqn{\chi^2}-distributed with \eqn{k} degrees of freedom, \eqn{k} being the difference in the dimensions
  of the unconstrained and constrained parameter spaces.

  Note that this function does \strong{not} verify that the two models are actually nested.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: print method
}}

\examples{
\donttest{
# GMAR p=1, M=2 model:
fit12 <- fitGSMAR(simudata, p=1, M=2, model="GMAR", ncalls=1, seeds=1)

# GMAR p=1, M=2 model AR parameters restricted to be the same in both
# regimes:
fit12r <- fitGSMAR(simudata, p=1, M=2, model="GMAR", restricted=TRUE,
                   ncalls=1, seeds=1)

# Test with likelihood ratio test whether the AR parameters are the same in
# both regimes:
LR_test(fit12, fit12r)
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distribution.	arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{Wald_test}}, \code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{diagnostic_plot}},
 \code{\link{profile_logliks}}, \code{\link{quantile_residual_tests}}, \code{\link{cond_moment_plot}}
}
