% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_estimate_parameters}
\alias{system_estimate_parameters}
\title{Control Estimation Process}
\usage{
system_estimate_parameters(cfg, flowctl = "plot guess",
  analysis_name = "my_analysis", archive_results = TRUE)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{flowctl}{string to control what the flow of the function}

\item{analysis_name}{string containing the name of the analysis}

\item{archive_results}{boolean variable to control whether results will be archived}
}
\value{
parameter estimates
}
\description{
Manages the flow of parameter estimation using data specified with \code{system_define_cohort}.
}
\details{
The \code{flowctl} argument can have the following values
 \itemize{
  \item \code{"plot guess"} return the initial guess
  \item \code{"estimate"} perform estimation
  \item \code{"previous estimate as guess"} load previous estimate for \code{analysis_name} and use that as the initial guess
  \item \code{"plot previous estimate"} return the previous estimate for \code{analysis_name}
 }
}
